/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: ParamDict.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public interface ParamDict {

	/**
	 *  Add a parameter to the dictionary. For loopsteps the method with additional
	 * loopNr parameter has to be used.
	 * @param paramName the name of the parameter as found in table <i>OP_PARAM_T</i>
	 * @param theParameter a ParameterArray object representing a parameter to be stored.
	 * */
	public void put(String paramName, ParameterArray theParameter)
		throws M4Exception;
	
	/**
	 * @see put(String, Object), just with the loop nr as an additional parameter
	 * */
	public void put(String paramName, int loopNr, ParameterArray theParameter)
		throws M4Exception;

	/**
	 * replaces the parameter of referenced by a specific name for a specific loop nr
	 * @param paramName the name of the key - the parameter name
	 * @param loopNr the loop nr
	 * @param theParameter the new parameter value
	 */
	public void replace(String paramName, int loopNr, ParameterArray theParameter)
		throws M4Exception;

	/**
	 * Checks whether for the given parameter name an entry is stored.
	 * This method is independent of loopstep or not, in both cases any
	 * occurence will be noticed.
	 * @param paramName the name of the parameter
	 * */
	public boolean containsKey(String paramName);

	/** 
	 * Checks whether for the given parameter name and a specific loop nr.
	 * a parameter is stored.
	 * */
	public boolean containsKey(String paramName, int loopNr);

	/** 
	 * Checks whether the given object exists as a value in the dictionary.
	 * @param paramArray the object to check for
	 * @return <code>true</code> iff the object was found
	 * */
	public boolean containsParamArray(ParameterArray paramArray);

	/** 
	 * If the given object exists as a value in the dictionary, then
	 * this method removes it.
	 * @param paramArray the object to remove
	 * @return <code>true</code> iff the object could be removed
	 * */
	public boolean removeParamArray(ParameterArray paramArray);

	/**
	 * @param paramName the name of the parameter to be looked up 
	 * @return the parameter if stored, <code>null</code> otherwise.
	 * in case of loopsteps use the method <code>get(String, int)</code> instead.
	 * */
	public ParameterArray get(String paramName) throws M4Exception;

	/**
	 * @param paramName the name of the parameter to be looked up 
	 * @param loopNr the loop nr. for which to look up the parameter.
	 * Note that the first loopNr is "0", no matter if we have a looped
	 * parameter or not.
	 * @return the parameter if stored, <code>null</code> otherwise.
	 * */
	public ParameterArray get(String paramName, int loopNr);

	/**
	 * @param paramName name of a parameter
	 * @return <code>true</code> iff the specified parameter is looped in the current step.
	 * */
	public boolean isLooped(String paramName);

}
/*
 * Historie
 * --------
 * 
 * $Log: ParamDict.java,v $
 * Revision 1.4  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
