/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler
 * @version $Id: OperatorGroup.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public interface OperatorGroup {

	/**
	 * @return a <code>Collection</code> of IDs of type <code>Long</code>
	 * representing operator groups. This IDs can be used to query further
	 * information about the group using the methods of this class.
	 */	
	public Collection getTopLevelOperatorGroups();
	
	/** 
	 * @param id the ID of an operator group
	 * @return the name of the operator group with the specified ID
	 */
	public String getGroupName(Long id);

	/** 
	 * @param id the ID of an operator group
	 * @return an <code>Operator</code> if the ID refers to a single operator
	 * entry, rather than to a group.
	 */
	public Operator getOperator(Long id) throws M4Exception;

	/** 
	 * @param id the ID of an operator group
	 * @return the ID of the parent operator group or <code>null</code>, if the ID
	 * belongs to a top-level operator group.
	 */
	public Long getParentGroup(Long id);
	
	/** 
	 * @param id the ID of an operator group
	 * @return a <code>Collection</code> of the ID of all child operator groups
	 * (or operator instances) referred to with their <code>Long</code> IDs.
	 * If the specified id is unknown or does not contain sub-elements, then
	 * <code>null</code> is returned.
	 */
	public Collection getChildGroups(Long id);
}
/*
 * Historie
 * --------
 * 
 * $Log: OperatorGroup.java,v $
 * Revision 1.4  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:23  hakenjos
 * Initial version!
 *
 */
