/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: MultiColumnFeature.java,v 1.4 2006/09/27 14:59:57 euler Exp $
 */
public interface MultiColumnFeature extends Feature {

	//methods from core

	/**
	 * Getter method.
	 * 
	 * @return all BaseAttributes that are bundled in this MCF.
	 */
	public Collection getBaseAttributes() throws M4Exception;

	/**
	 * Setter method.
	 * 
	 * @param a <code>Collection</code> of the new BaseAttributes for this MCF.
	 */
	public void setBaseAttributes(Collection theAttribs) throws M4Exception;

	/**
	 * @param ba a <code>BaseAttribute</code>
	 * @return <code>true</code> if a <code>BaseAttribute</code> with the same ID is already
	 * linked to this <code>MultiColumnFeature</code>
	 * */
	public boolean hasBaseAttribute(BaseAttribute ba) throws M4Exception;

	public void addBaseAttribute(BaseAttribute ba) throws M4Exception;

	/**
	 * @param name the name 
	 * @return the <code>BaseAttribute</code> with the given name
	 *         if there is one (ignoring case); <code>null</code> otherwise
	 */
	public BaseAttribute getBaseAttributeByName(String name)
		throws M4Exception;

	public boolean removeBaseAttribute(BaseAttribute ba) throws M4Exception;

	/**
	 * Copy this MultiColumnFeature.
	 * 
	 * @return A clone of this MCF with ID 0, because it does not exist in
	 * 		   the DB yet.
	 */
	public MultiColumnFeature copy() throws M4Exception;

	/**
	 * @return <code>true</code> iff this <code>MultiColumnFeature</code> has
	 * been &quot;deselected&quot; by a <code>FeatureSelection</code> operator
	 * or has not been connected by the user.
	 * A <code>MultiColumnFeature</code> is considered deselected, if one of
	 * its <code>BaseAttributes</code> has been deselected.
	 */
	public boolean isDeselected() throws M4CompilerError;
}
/*
 * Historie
 * --------
 * 
 * $Log: MultiColumnFeature.java,v $
 * Revision 1.4  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
