/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.awt.Point;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: GraphicalM4Object.java,v 1.5 2006/09/27 14:59:58 euler Exp $
 */
public interface GraphicalM4Object extends M4Data {
	
	/**
	 * Set the coordinates for this object.
	 * 
	 * @param point The Point with the new coordinates for this M4 object.
	 */
	public void setPoint(Point location) throws M4Exception;
	
	/**
	 * Get the coordinates of this object.
	 * 
	 * @return A Point object with the coordinates of this M4 object.
	 * @throws M4Exception
	 */
	public Point getPoint() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: GraphicalM4Object.java,v $
 * Revision 1.5  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/12 11:33:11  euler
 * Changed the way coordinates are stored completely.
 *
 * Revision 1.1  2006/01/03 09:54:23  hakenjos
 * Initial version!
 *
 */
