/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * MiningMart Feature (subclasses BaseAttribute and MultiColumnFeature)
 * 
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: Feature.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public interface Feature extends ParameterObject {

	//methods from core

	/**
	 * This method indicates if an input feature corresponds to an
	 * output feature, or if two input features correspond, e.g.
	 * for UNION operations.
	 * 
	 * Additionally to comparing names the types (<i>BaseAttribute</i>
	 * or <i>MultiColumnFeature</i>) have to be equal.
	 *
	 * @param  f the feature to compare this one to
	 * @return <true> iff the features are corresponding.
	*/
	public boolean correspondsTo(Feature f);

	public abstract Concept getConcept() throws M4Exception;

	/**
	 * Set the concept this BaseAttribute belongs to.
	 * @param c the <code>Concept</code>
	 */
	public void setConcept(Concept c) throws M4Exception;
	
	/**
	 * Create a copy of this Feature and attach it to the given 
	 * Concept. The relational M4 level is not copied.
	 *  
	 * @return a copy of this Feature
	 * @throws M4CompilerError
	 */
	public Feature copy(Concept c) throws M4Exception;
	
	/**
	 * @return <code>true</code> iff this <code>Feature</code> has
	 * been &quot;deselected&quot; by a <code>FeatureSelection</code> operator
	 * or has not been connected by the user.
	 */
	public abstract boolean isDeselected() throws M4CompilerError;

    /**
     * Return the Parameter object that represents this
     * Feature as an output parameter (of a certain step).
     *  
     * @return a Parameter object
     */
    public Parameter getParameterWhereThisIsOutputFeature() throws M4Exception;
    
	//methods from old interface

	/*
	 * This method may be used by the client to manage a higher form
	 * of validity for an object. At this point it has not yet been
	 * defined however what 'functionally valid' means! Currently this
	 * information is also not saved in the M4 Meta Data Schema.
	 */
	// boolean isFunctionallyValid(); // TE: very likely not needed

	/*
	 * This method may be used by the client to manage a higher form
	 * of validity for an object. At this point it has not yet been
	 * defined however what 'functionally valid' means! Currently this
	 * information is also not saved in the M4 Meta Data Schema.
	 */
	// void setFunctionallyValid(boolean functionallyValid); // TE: very likely not needed

	/**
	 * This method returns information about the validity
	 * of the object. The returned value denotes if the
	 * object is valid or not.
	 */
	boolean isRelationallyValid() throws M4Exception;
	
	/**
	 * Removes the link between this feature and all of its columns.
	 * This is needed to disconnect the conceptual and relational level.
	 * 
	 * @throws M4Exception
	 */
	public void removeLinkToColumns() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: Feature.java,v $
 * Revision 1.4  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
