/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: Constraint.java,v 1.11 2006/09/27 14:59:58 euler Exp $
 */
public interface Constraint extends M4Data {

	/*
	 * Public constants used for the different types of Constraints. 
	 */
	public static final String TYPE_IS_LOOPED          = "IS_LOOPED";
	public static final String TYPE_SAME_FEATURES      = "SAME_FEAT";
	public static final String TYPE_COMPATIBLE         = "COMP";
	public static final String TYPE_CONTAINED_IN       = "IN";
	public static final String TYPE_DATATYPE           = "TYPE";
	public static final String TYPE_GREATER_THAN       = "GT";
	public static final String TYPE_GREATER_OR_EQUAL   = "GE";
	public static final String TYPE_LESSER_THAN        = "LT";
	public static final String TYPE_LESSER_OR_EQUAL    = "LE";
	public static final String TYPE_ONE_OF             = "ONE_OF";
	public static final String TYPE_SAME_DATATYPE      = "SAME_TYPE";
	public static final String TYPE_SUM_MUST_BE_ONE    = "SUM";		
	public static final String TYPE_COORDINATED_ARRAYS = "COORD";		
	public static final String TYPE_ATTRIB_IN_REL_FROM = "IN_RELFROM";	
	public static final String TYPE_ATTRIB_IN_REL_TO   = "IN_RELTO";
	public static final String TYPE_SAME_FEAT_EXCEPT   = "ALL_EXCEPT";
	public static final String TYPE_RENAME_ATTRIB      = "RENAME_OUT";
	public static final String TYPE_MATCH_ATTRIBS_BY_CONCEPTS = "MATCHBYCON";
	public static final String TYPE_OUT_ATTRIB_TYPE    = "OUT_TYPE";		
	public static final String TYPE_CREATE_ATTRIB_BY   = "CREATE_BY";		
	public static final String TYPE_CREATE_ATTRIB_SUFF = "CR_SUFFIX";	
	public static final String TYPE_FEAT_FROM_RELFR    = "FEAT_RFR";	
	public static final String TYPE_FEAT_FROM_RELTO    = "FEAT_RTO";	
	public static final String TYPE_NO_COMMON_FEATURES = "NO_COMMON";	
	public static final String TYPE_FROM_CON_FOR_REL   = "FROMCON";	
	public static final String TYPE_TO_CON_FOR_REL     = "TOCON";	
	public static final String TYPE_CROSS_CON_FOR_REL  = "CROSSCON";
	public static final String TYPE_FROM_KEY_FOR_REL   = "FROMKEY";
	public static final String TYPE_TO_KEY_FOR_REL     = "TOKEY";
	public static final String TYPE_CROSS_FROM_KEY_FOR_REL = "CR_FROMKEY";
	public static final String TYPE_CROSS_TO_KEY_FOR_REL = "CR_TOKEY";
	public static final String TYPE_GET_VALUES_FROM_ATTRIB = "USE_VALS";

	/**
	 * Gets the myObj1.
	 * @return Returns a String
	 */
	public String getObj1();

	/**
	 * Gets the myObj2.
	 * @return Returns a String
	 */
	public String getObj2();

	/**
	 * Gets the Operator
	 * @return Returns an <code>Operator</code>
	 */
	public Operator getTheOperator();

	/**
	 * Gets the myType.
	 * @return Returns a String
	 */
	public String getType();

	/**
	 * Sets the myObj1.
	 * @param myObj1 The myObj1 to set
	 */
	public void setObj1(String myObj1);

	/**
	 * Sets the myObj2.
	 * @param myObj2 The myObj2 to set
	 */
	public void setObj2(String myObj2);

	/**
	 * Sets the Operator.
	 * @param operator The <code>Operator</code> to set
	 */
	public void setTheOperator(Operator operator) throws M4Exception;

	/**
	 * Sets the myType.
	 * @param myType The myType to set
	 */
	public void setType(String myType);

	//methods from old interface

	// TE: probably never used
	// public String getShortDescription();
	// public void setShortDescription(String shortDescription);
	// public String getSql();
	// public void setSql(String sql);
}
/*
 * Historie
 * --------
 * 
 * $Log: Constraint.java,v $
 * Revision 1.11  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.10  2006/09/21 11:42:42  euler
 * *** empty log message ***
 *
 * Revision 1.9  2006/08/19 18:43:26  euler
 * Some Bugfixes
 *
 * Revision 1.8  2006/08/16 15:09:12  euler
 * *** empty log message ***
 *
 * Revision 1.7  2006/08/15 09:57:34  euler
 * New constraints for creating output concepts
 *
 * Revision 1.6  2006/06/19 15:37:13  euler
 * Bugfixes
 *
 * Revision 1.5  2006/06/16 16:26:32  euler
 * New operator "FeatureConstructionByRelation"
 *
 * Revision 1.4  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/05 14:11:37  euler
 * Bugfixes
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
