/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

/**
 * Access to the conceptual datatypes used in M4.
 * 
 * @author Timm Euler, Martin Scholz
 * @version $Id: ConceptualDatatypes.java,v 1.4 2006/09/27 14:59:57 euler Exp $
 */
public interface ConceptualDatatypes {
	
	/*
	 * public String constants to refer to the specific conceptual datatypes.
	 */
	
	public static final String CDT_NOMINAL 		= "NOMINAL";
	public static final String CDT_CATEGORIAL   = "CATEGORIAL";
	public static final String CDT_KEYATTRIB 	= "KEYATTRIB";
	public static final String CDT_CONSTANT 	= "CONSTANT";
	public static final String CDT_TIMEGROUP 	= "TIMEGROUP";
	public static final String CDT_SPATIAL 		= "SPATIAL";
	public static final String CDT_NUMERIC 		= "NUMERIC";
	public static final String CDT_ORDINAL 		= "ORDINAL";
	public static final String CDT_SCALAR 		= "SCALAR";
	public static final String CDT_TIME 		= "TIME";
	public static final String CDT_BINARY 		= "BINARY";
	
	public static final String[] CDTYPES=new String[]{	CDT_NOMINAL,
														CDT_NUMERIC,
														CDT_BINARY,
														CDT_TIME};
	
	/** 
	 * Mapping listing all compatible pairs of datatypes, where the left datatype is
	 * more general than the right one.
	 */
	public static final String[][] datatypeCompatibilities = { 
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_CATEGORIAL, 
			edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_NOMINAL },
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_SCALAR, 
			edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_NUMERIC },
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_NUMERIC, 
				edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_ORDINAL },
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_SCALAR, 
			edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_ORDINAL },
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_ORDINAL, 
			edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_BINARY },
		{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_SCALAR, 
			edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_BINARY },
			{ edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_CATEGORIAL, 
				edu.udo.cs.miningmart.m4.ConceptualDatatypes.CDT_BINARY } };
	
	/**
	 * @param name the name of a conceptual datatype (case senitive)
	 * @return the id representing this datatype or <code>0</code> if not found
	 */
	public long getIdForName(String name);

	/**
	 * @param id the ID of a conceptual datatype
	 * @return the conceptual datatype's name
	 */
	public String getNameForId(long id);
}
/*
 * Historie
 * --------
 * 
 * $Log: ConceptualDatatypes.java,v $
 * Revision 1.4  2006/09/27 14:59:57  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
