/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.installer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.db.DB;

/**
 * A <code>JDialog</code> that asks which DBMS (Oracle, Postgres
 * or Mysql) the user would like to use.
 * 
 * @author Timm Euler
 * @version $Id: $
 */
public class AskForDbmsDialog extends JDialog implements ActionListener{
			
	private JButton okButton, cancelButton;
	private JRadioButton mysqlButton, postgresButton, oracleButton;
	private Vector userSelection;
	private ActionListener myListener;
	
	public AskForDbmsDialog(Frame owner, Vector storeChoiceHere, ActionListener al){
		super(owner, true);
		this.userSelection = storeChoiceHere;
		this.myListener = al;
		this.updateDisplay();
	}
	
	private void updateDisplay() {
		this.setVisible(false);
		
		this.initComponents();
		
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);	
		this.pack();	
		setSize(350, 200);	
		Dimension size = this.getSize();	
		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);
	}
	
	private void initComponents(){
		
		JPanel toppanel=new JPanel();
		toppanel.setLayout(new BorderLayout(5,5));
		toppanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		this.getContentPane().add(toppanel);

		//Infotext
		JPanel infopanel=new JPanel();
		infopanel.setLayout(new GridLayout(2,1,5,5));
		infopanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		toppanel.add(infopanel,BorderLayout.NORTH);	

		JLabel label=new JLabel();
		label.setText(Resource.getString("ASK_DBMS"));
		Font font=new Font("SansSerif",Font.BOLD,15);
		label.setFont(font);
		label.setHorizontalAlignment(SwingConstants.CENTER);	
		infopanel.add(label);
		
		// choice buttons
		JPanel choicePanel = new JPanel();
		// set the initial choice if there is one:
		short selected = -1;
		if (this.userSelection != null && ( ! this.userSelection.isEmpty()))
			selected = ((Short) this.userSelection.firstElement()).shortValue();
		else selected = DB.MYSQL;
		mysqlButton = new JRadioButton("Mysql", (selected == DB.MYSQL));
		postgresButton = new JRadioButton("Postgres", (selected == DB.POSTGRES));
		oracleButton = new JRadioButton("Oracle", (selected == DB.ORACLE));
		ButtonGroup theGroup = new ButtonGroup();
		theGroup.add(mysqlButton);
		theGroup.add(postgresButton);
		theGroup.add(oracleButton);
		choicePanel.add(mysqlButton);
		choicePanel.add(postgresButton);
		choicePanel.add(oracleButton);
	
		toppanel.add(choicePanel, BorderLayout.CENTER);
		
		// exit Buttons
		cancelButton=new JButton(Resource.getString("CANCEL"));
		cancelButton.addActionListener(this);
		okButton=new JButton(Resource.getString("OK"));
		okButton.addActionListener(this);

		JPanel buttonPanel=new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
		buttonPanel.add(Box.createHorizontalGlue());
		
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));			
		buttonPanel.add(cancelButton);	
		buttonPanel.add(okButton);
		toppanel.add(buttonPanel,BorderLayout.SOUTH);
	}	

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event) {
		if (!(event.getSource() instanceof JButton))
			return;
		JButton source=(JButton) event.getSource();
		if (source.getText().equals(okButton.getText()) &&
			this.userSelection != null){
			if (this.mysqlButton.isSelected()) {
				Short s = new Short(DB.MYSQL);
				if (this.userSelection.isEmpty()) 
					this.userSelection.add(s); 
				else this.userSelection.set(0, s);
			}
			if (this.postgresButton.isSelected()) {
				if (this.userSelection.isEmpty())
					this.userSelection.add(new Short(DB.POSTGRES));
				else this.userSelection.set(0, new Short(DB.POSTGRES));
			}
			if (this.oracleButton.isSelected()) {
				if (this.userSelection.isEmpty())
					this.userSelection.add(new Short(DB.ORACLE));
				else this.userSelection.set(0, new Short(DB.ORACLE));
			}
		}
		
		if (this.myListener != null) {
			this.myListener.actionPerformed(null);
			dispose();
		}
	}
}
/*
 * Historie
 * --------
 *
 * $Log: $
 */
