package edu.udo.cs.miningmart.gui.util;

import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

/**
 * A MiningMart-specific UI-Delegate for JTabbedPanes;
 * its use is set as default for JTabbedPanes in 
 * MiningMartApplication.main(String[]). It catches an
 * exception that sometimes mysteriously occurs (the 
 * exception does no harm but produces an annoying log 
 * message).
 * 
 * @author timm
 */
public class MmTabbedPaneUI extends MetalTabbedPaneUI {

    public static ComponentUI createUI(JComponent c) {
        return new MmTabbedPaneUI();
    }
    
	/**
	 * This method is overridden since it sometimes throws
	 * an ArrayIndexOutOfBoundsException for no apparent 
	 * reason. This method simply calls the super class method
	 * and catches the exception if it occurs.
	 * 
	 * @param g
	 * @param tabPlacement
	 * @param selectedIndex
	 */
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
    	try {
    		super.paintTabArea(g, tabPlacement, selectedIndex);
    	}
    	catch (ArrayIndexOutOfBoundsException ae) {
    	}
    }
}
