/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.util;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.compiler.CompilerAccess;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Martin Scholz, Daniel Hakenjos
 * @version $Id: GarbageCollector.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class GarbageCollector {

	public GarbageCollector(MiningMartApplication app, Case m4case) {
		if (m4case == null)
			return;
			
		CompilerAccess ca = app.getCompilerAccess();
	
		try {
			if (ca == null) {
				throw new M4CompilerError("Error: Compiler Access not set");
			}
			ca.deleteTrashForCase(m4case.getId());
			M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("CASE_TRASH"));
			JOptionPane.showMessageDialog(app,
   				Resource.getString("CASE_TRASH"),
   				Resource.getString("DIALOG_INFO_TITLE"),
   				JOptionPane.INFORMATION_MESSAGE);	
		}
		catch (Exception e) {
			M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
			JOptionPane.showMessageDialog(app,
   				e.getMessage(),
   				Resource.getString("DIALOG_ERROR_TITLE"),
   				JOptionPane.ERROR_MESSAGE);	
		}
	}
}
/*
 * Historie
 * --------
 *
 * $Log: GarbageCollector.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
