package edu.udo.cs.miningmart.gui.util;

import java.awt.event.ActionListener;
import java.util.HashMap;

import javax.swing.JFrame;

import org.musoft.limo.application.Resource;

/**
 * A slightly modified configuration window for
 * DB settings for Mysql.
 * @author timm
 *
 */
public class DbConfigEditorWindowForMysql extends DbConfigEditorWindow {

	// Semantics of fields: {VariableName, NameUsedInGui, Default}
	private final String[][] mapping = new String[][] {
		{DbConfigEditor.VAR_DB_DRIV, Resource.getString("DBCONFIG_DB_DRIVER"), "jdbc:mysql:"},
		{DbConfigEditor.VAR_DB_HOST, Resource.getString("DBCONFIG_DB_HOST"), "localhost"},
		{DbConfigEditor.VAR_DB_PORT, Resource.getString("DBCONFIG_DB_PORT"), "3306"},
	
		{null, "", null},  // separator line

		{DbConfigEditor.VAR_M4_DB_NAME, Resource.getString("DBCONFIG_M4_DB_NAME"), null,},
		{DbConfigEditor.VAR_M4_USER,  Resource.getString("DBCONFIG_M4_USER"),           null},
		{DbConfigEditor.VAR_M4_PASS,  Resource.getString("DBCONFIG_M4_PASS"),       null},
		{DbConfigEditor.VAR_BUS_DB_NAME, Resource.getString("DBCONFIG_BUS_DB_NAME"), null,},
		{DbConfigEditor.VAR_BUS_USER, Resource.getString("DBCONFIG_BUS_USER"),         null},
		{DbConfigEditor.VAR_BUS_PASS, Resource.getString("DBCONFIG_BUS_PASS"), null}
	};

	
	// *** Constructor ***
	public DbConfigEditorWindowForMysql(JFrame parent,HashMap values, ActionListener saveAction) {
		super(parent, values, saveAction);
	}

	protected String[][] getMapping() {
		return this.mapping;
	}	
}
