/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.gui.application.CreateCaseDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.XMLFileFilter;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.M4Xml;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;

/**
 * this class is used to import a case. The case must be exported with the class
 * CaseExporter to ensure the right ordering of elements in the file. First element
 * must be a case, then everything concerning the concept level and then everything
 * concerning the chain level. In every level an ordering top down is a must.
 * @author Martin Scholz, Daniel Hakenjos
 * @version $Id: CaseImporter.java,v 1.4 2006/09/27 15:00:04 euler Exp $
 */

public class CaseImporter {

	private MiningMartApplication app;

  private InputStream inputStream;
  private int retVal = JOptionPane.YES_OPTION;
  private boolean withColumns = false;
  private boolean noFile = false;

  public CaseImporter(MiningMartApplication parent) {
  	this.app=parent;
    init();
  }

  /**
   * Selects the path and filename and opens the output stream
   */
  public void init() {
    JFileChooser chooser = new JFileChooser(app.getWorkingDir());
    chooser.setFileFilter(new XMLFileFilter());
    retVal = chooser.showOpenDialog(app);
    File file = chooser.getSelectedFile();
    if (file==null) {
      noFile = true;
      return;
    }
    
    if (!file.exists()){
		JOptionPane.showMessageDialog(app,Resource.getString("ERROR_FILE_NOT_EXISTS")+"\n"+file.getName(),Resource.getString("DIALOG_ERROR_TITLE"),JOptionPane.ERROR_MESSAGE);
		noFile=true;
		return;
    }

    noFile=false;
    String filename = file.getPath();
    
    try {
    	inputStream = new BufferedInputStream(new FileInputStream(filename));
    }
    catch (FileNotFoundException fnfe) {
    	M4Interface.print.doPrint(Print.ERROR,fnfe.getMessage(),fnfe);
		retVal = JOptionPane.CANCEL_OPTION;
    }
    app.setWorkingDir(file.getParent());
  }

  public boolean importCase() throws IOException{
    if (noFile)
      return false;

		DB db = M4Interface.getInstance().getM4db();
		try {
			Case m4case = M4Xml.importCase(this.inputStream, db, XmlInfo.M4_XML_VERSION);
			CreateCaseDialog ccd = new CreateCaseDialog(app, Resource.getString("SET_NAME_FOR_CASE"), true);
			ccd.showCreateDialog(m4case);
			M4Interface.setCurrentCase(m4case);
			
		}
		catch (edu.udo.cs.miningmart.exception.MiningMartException e) {
			throw new IOException(e.getMessage());	
		}
	return true;
  }

}
/*
 * Historie
 * --------
 *
 * $Log: CaseImporter.java,v $
 * Revision 1.4  2006/09/27 15:00:04  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
