/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.Component;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A renderer for the first column of the <code>StepParameterTable</code>.
 * @author Daniel Hakenjos
 * @version $Id: StepParameterRenderer.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public class StepParameterRenderer extends DefaultTableCellRenderer{
	
	private Step step;
	
        /**
         *Constructs a new <code>StepParameterRenderer</code>.
         */
	public StepParameterRenderer(Step step){
		this.step=step;
	}


    /**
     *Gets the renderer-component of the tablecell.
     *The name of the <code>OpParam</code> is displayed in a <codeJLabel</code>.
     *If the <code>OpParam</code> is not optional then the font is in PLAIN-style.
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        String key=new String("");
        if (value instanceof String)
            key=(String) value;

        Component c = super.getTableCellRendererComponent(table, key, isSelected, hasFocus, rowIndex, colIndex);

		if (colIndex!=0){
			return c;
		}



        JLabel label=(JLabel) c;

   	    c.setFont(c.getFont().deriveFont(Font.BOLD, c.getFont().getSize()));
   	    try{
   	    	
	   	    OpParam opparam=((OpParam)(step.getTheOperator().getOpParams().toArray()[rowIndex]));
			if (opparam.isInput()){
				label.setBackground(Resource.getColor("STEPSETTINGS_COLOR_INPUT"));
			}else{
				label.setBackground(Resource.getColor("STEPSETTINGS_COLOR_OUTPUT"));
			}

			if (opparam.isOptional()){
		   	    c.setFont(c.getFont().deriveFont(Font.PLAIN, c.getFont().getSize()));
			}else{
		   	    c.setFont(c.getFont().deriveFont(Font.BOLD, c.getFont().getSize()));
			}
			
			if (opparam.isCoordinated()){
//				label.setForeground(Resource.getColor("STEPSETTINGS_COLOR_COORDINATED"));
				label.setBorder(BorderFactory.createLineBorder(Resource.getColor("STEPSETTINGS_COLOR_COORDINATED"),2));
			}
			

			label.setToolTipText(opparam.getDocumentation());
   	    }catch(MiningMartException error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
   	    }
   	    
        return label;
    }

}
/*
$Log: StepParameterRenderer.java,v $
Revision 1.4  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
