/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for single-selection of a <code>Relation</code>.
 * @author Daniel Hakenjos
 * @version $Id: SingleRelationEditor.java,v 1.5 2006/09/27 14:59:58 euler Exp $
 */
public class SingleRelationEditor extends SingleSelectEditor {

	private StepParameterTable table;
	
    /**
     *Constructs a new <code>SingleRelationEditor</code>.
     */
	public SingleRelationEditor(MiningMartApplication app,Step step, OpParam opParam){
		super(app,step,opParam);
	}

    /**
     *Constructs a new <code>SingleBaseAttributeEditor</code>.
     */
	public SingleRelationEditor(MiningMartApplication app,StepParameterTable table, OpParam opParam){
		super(app,table.getTheStep(),opParam);
		this.table=table;
	}
	
	
	public void init(){
		super.init();

		if (opParam.isInput()){
			if ((paramobject!=null)&&(paramobject instanceof Relation)){
				this.textfield.setText(((Relation) paramobject).getName());
			}
		}else{
			Collection coll=getParameterCollection();
			Iterator iter=coll.iterator();
			if (iter.hasNext()){
				this.textfield.setText((String) iter.next());
			}
		}
	}


	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try{
			Collection relations=M4Interface.getCurrentCase().getAllRelations();
			String[] data=new String[relations.size()];		
			
			int c=0;
			Iterator iter=relations.iterator();
			while(iter.hasNext()){
				data[c]=((Relation) iter.next()).getName();
				c++;
			}
			
			SingleSelectDialog dialog=new SingleSelectDialog(app,Resource.getString("STEPSETTINGS_TITLE_RELATION"),Resource.getString("STEPSETTINGS_TITLE_SELECT_RELATION"),data, true);
			if (dialog.getExitAction()==SingleSelectDialog.OK){
				String selected=dialog.getSelectedDataItem();
				textfield.setText(selected);
				
				iter=relations.iterator();
				Relation selectedR=null;
				boolean found=false;
				while ((iter.hasNext())&&(!found)){
					selectedR=(Relation) iter.next();
					if (selectedR.getName().equals(selected)){
						found=true;
					}
				}
				LinkedList list=new LinkedList();
				if (found){
					list.add(selectedR);
					this.paramobject=selectedR;
				}
				setParameterCollection(list);
				this.fireStateChanged();
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		if (opParam.isInput())
			return false;

		Collection coll;
		for(int loop=1;loop<=numberofloops;loop++){
			coll=(Collection) this.oldparamcollections.get(loop-1);
			if (coll==null){
				return false;
			}
			if (coll.isEmpty()){
				return false;
			}
		}
		
		//only returns true if in all loops one relation is specified
		return true;
	}


}
/*
$Log: SingleRelationEditor.java,v $
Revision 1.5  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.4  2006/06/13 13:30:42  euler
Updates

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
