/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JOptionPane;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for the <code>StepParameterTable</code>.
 * @author Daniel Hakenjos
 * @version $Id: SelectEditor.java,v 1.8 2006/09/27 14:59:58 euler Exp $
 */
public abstract class SelectEditor extends ParameterEditor{

	protected StepParameterTable table;
	protected JButton button;
	
    /**
     *Constructs new <code>SelectEditor</code> with a <code>JTextField</code>.
     */
	public SelectEditor(MiningMartApplication app,Step step, OpParam opParam){
		super(app,step,opParam);
	}
		
	/**
	 * Returns a collection of BaseAttributes. The parameter object of the parameter
	 * given by theAttribOpParam must be chosen from the returned collection.
	 * If null is returned, no knowledge is available about where to select from.
	 * 
	 * @param theAttribOpParam
	 * @return
	 */
	protected Collection getListOfAttributesToSelectAttributeFrom(OpParam theAttribOpParam) {
		try {
			Collection opParamsToSelectFrom = null;
			opParamsToSelectFrom = step.getOpParamsToSelectFeatureParamObjectsFrom(theAttribOpParam);
			if (opParamsToSelectFrom == null) {
				return null;
			}
			Collection conceptsToSelectAttribFrom = new Vector();
			Iterator it = opParamsToSelectFrom.iterator();
			while (it.hasNext()) {
				OpParam anOpPar = (OpParam) it.next();
				if (anOpPar.isConceptParameter()) {
					Collection theConcepts = this.table.getConceptEditorValues(anOpPar.getName());
					if (theConcepts != null) {
						conceptsToSelectAttribFrom.addAll(theConcepts);
					}
					else {
						return null;
					}
				}
				if (anOpPar.isRelationParameter()) {
					boolean takeFrom = this.step.isAttribToTakeFromFromConcept(theAttribOpParam, anOpPar);
					boolean takeTo = this.step.isAttribToTakeFromToConcept(theAttribOpParam, anOpPar);
					if ( (( ! takeFrom) && ( ! takeTo)) 
						 ||
						 (takeFrom & takeTo)) {
						this.showErrorMessage("Cannot determine whether the parameter is from the FromConcept\nor the ToConcept of the relation given by another parameter.");
						return null;
					}
					Collection rels = this.table.getRelationEditorValues(anOpPar.getName());
					Relation rel = null;
					if (rels == null || rels.isEmpty()) {
						return null;
					}
					else {
						String relName = (String) rels.iterator().next();
						rel = this.step.getTheCase().getRelation(relName);
					}
					if (rel == null) {
						return null;
					}
					if (takeFrom) {
						conceptsToSelectAttribFrom.add(rel.getTheFromConcept().getName());						
					}
					if (takeTo) {
						conceptsToSelectAttribFrom.add(rel.getTheToConcept().getName());
					}
				}
			}
			Collection battribs = new LinkedList();
			Iterator iter = conceptsToSelectAttribFrom.iterator();
			Concept concept;
			while (iter.hasNext()) {
				String conceptName = (String) iter.next();
				concept = M4Interface.getCurrentCase().getConcept(conceptName);
				if (concept!=null){
					Collection c=concept.getAllBaseAttributes();
					Iterator iter2=c.iterator();
					BaseAttribute ba;					
					while (iter2.hasNext()){
						ba=(BaseAttribute) iter2.next();
						if (step.isVisible(ba)){
							battribs.add(ba);
						}
					}
				}
			}
			if (battribs == null || battribs.isEmpty()) {
				return null;
			}
			return battribs;
		} catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			return null;
		}
	}
	
	protected void showErrorMessage() {
		String standardMessage = "Please specify other parameters first, so that the selection for this one is known!";
		this.showErrorMessage(standardMessage);
	}
	
	protected void showErrorMessage(String message) {
		JOptionPane.showMessageDialog(null,
				message,
				"Error during parameter editing",
				JOptionPane.INFORMATION_MESSAGE);
	}
}
/*
$Log: SelectEditor.java,v $
Revision 1.8  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.7  2006/08/19 19:35:15  euler
bugfix

Revision 1.6  2006/06/20 07:51:42  euler
Bugfixes

Revision 1.5  2006/06/19 15:37:12  euler
Bugfixes

Revision 1.4  2006/06/18 15:13:05  euler
Bugfixes

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
