/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for mulit-selections of <code>Value</code>s.
 * @author Daniel Hakenjos
 * @version $Id: ListValueEditor.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public class ListValueEditor extends ListSelectEditor{

	private SelectEditor lbae;
	
	/**
	 *Constructs new <code>ListValueEditor</code>.
	 */
	public ListValueEditor(
			MiningMartApplication app,
			Step step, 
			OpParam opParam,
			SelectEditor editorWithAttribParams){
		super(app,step, opParam);
		this.lbae = editorWithAttribParams;
	}
	
	public void init(){
		super.init();
		this.selected_data=new String[0];

		Collection coll=getParameterCollection();
		if (coll!=null){
			this.selected_data=new String[coll.size()];
			Iterator iter=coll.iterator();
			int index=0;
			while (iter.hasNext()){
				if (opParam.isInput()){
					selected_data[index]=((Value) iter.next()).getValue();
				}else{
					selected_data[index]=(String) iter.next();
				}
				index++;
			}
		}
		setDataItems(selected_data);
	}
	
	

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		ListSelectDialog dialog = null;
		boolean useEstimations = false;
		try {
			useEstimations = this.opParam.isDependentValueParameter();
		}
		catch (M4Exception m4e) {
			M4Interface.print.doPrint(Print.ERROR,m4e.getMessage(), m4e);			
		}
		if (useEstimations) {
			// get the array of attributes to get the values from
			BaseAttribute[] attribs = this.getAttribs();
			// get the current step
			// add them to the following call
			dialog=
				new ListSelectDialog(
						app,
						Resource.getString("STEPSETTINGS_TITLE_VALUE"),
						Resource.getString("STEPSETTINGS_TITLE_SELECT_VALUE"),
						selected_data,
						opParam.getMinArg(),
						opParam.getMaxArg(),
						attribs,
						this.step);
		}
		else dialog=
				new ListSelectDialog(
						app,
						Resource.getString("STEPSETTINGS_TITLE_VALUE"),
						Resource.getString("STEPSETTINGS_TITLE_SELECT_VALUE"),
						selected_data,
						opParam.getMinArg(),
						opParam.getMaxArg());
		
		if (dialog.getExitAction()==ListSelectDialog.OK){
			selected_data=dialog.getSelectedDataItems();
			this.setDataItems(selected_data);
			
			Collection coll=getParameterCollection();
			Iterator iter=null;
			if (coll!=null){
				iter=coll.iterator();
			}
			LinkedList list=new LinkedList();
			try{
				Value value;
				for(int s=0;s<selected_data.length;s++){
					if ((iter!=null)&&(iter.hasNext())){
						value=(Value) iter.next();
					}else{
						value=opParam.createValueObject();
					}
					value.setValue(selected_data[s]);
					list.add(value);
				}
			}catch(M4Exception error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
			setParameterCollection(list);
			this.fireStateChanged();
			
		}
	}
	
	private BaseAttribute[] getAttribs() {
		if (this.lbae == null)
			return null;
		Collection allSetParams = this.lbae.paramcollections;
		Iterator loopIt = allSetParams.iterator();
		Collection v = new Vector();
		while (loopIt.hasNext()) {
			Collection oneLoopParams = (Collection) loopIt.next();
			Iterator innerIt = oneLoopParams.iterator();
			while (innerIt.hasNext()) {
				BaseAttribute ba = (BaseAttribute) innerIt.next();
				v.add(ba);
			}
		}
		BaseAttribute[] ret = new BaseAttribute[v.size()];
		Iterator vIt = v.iterator();
		int i = 0;
		while (vIt.hasNext()) {
			ret[i] = (BaseAttribute) vIt.next();			
			i++;
		}
		return ret;
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		//dies kann doch gar kein output sein

		return false;
	}

}
/*
$Log: ListValueEditor.java,v $
Revision 1.4  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
