/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for multi-selection of <code>Relations</code>s.
 * @author Daniel Hakenjos
 * @version $Id: ListRelationEditor.java,v 1.5 2006/09/27 14:59:58 euler Exp $
 */
public class ListRelationEditor extends ListSelectEditor {

	private StepParameterTable table;
	
        /**
         *Constructs a new <code>ListRelationEditor</code>.
         */
	public ListRelationEditor(MiningMartApplication app,Step step, OpParam opParam){
		super(app,step,opParam);
	}
	
	public ListRelationEditor(MiningMartApplication app, StepParameterTable table, OpParam opParam){
		super(app,table.getTheStep(), opParam);
		this.table = table;
	}
	
	public void init(){
		super.init();
		this.selected_data=new String[0];

		Collection coll=getParameterCollection();
		if (coll!=null){
			this.selected_data=new String[coll.size()];
			Iterator iter=coll.iterator();
			int index=0;
			while (iter.hasNext()){
				if (opParam.isInput()){
					selected_data[index]=((Relation) iter.next()).getName();
				}else{
					selected_data[index]=(String) iter.next();
				}
				index++;
			}
		}
		setDataItems(selected_data);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try{
			Collection relations=M4Interface.getCurrentCase().getAllRelations();
			this.data=new String[relations.size()];
			
			Iterator iter=relations.iterator();
			int c=0;
			while (iter.hasNext()){
				data[c]=((Relation) iter.next()).getName();
				c++;
			}
	
			ListSelectDialog dialog=new ListSelectDialog(app,Resource.getString("STEPSETTINGS_TITLE_RELATION"),Resource.getString("STEPSETTINGS_TITLE_SELECT_RELATION"),data,selected_data,true,opParam.getMinArg(),opParam.getMaxArg());
			if (dialog.getExitAction()==ListSelectDialog.OK){
				selected_data=dialog.getSelectedDataItems();
				this.setDataItems(selected_data);
				
				LinkedList list=new LinkedList();
				for(int s=0;s<selected_data.length;s++){
					iter=relations.iterator();
					Relation selectedR=null;
					boolean found=false;
					while ((iter.hasNext())&&(!found)){
						selectedR=(Relation) iter.next();
						if (selectedR.getName().equals(selected_data[s])){
							found=true;
						}
					}
					if (found){
						list.add(selectedR);
					}
				}
				setParameterCollection(list);
				this.fireStateChanged();
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		if (opParam.isInput())
			return false;

		Collection coll;
		Collection actual;
		for(int loop=1;loop<=numberofloops;loop++){
			coll=(Collection) this.oldparamcollections.get(loop-1);
			actual=(Collection) this.paramcollections.get(loop-1);
			if (coll==null){
				return false;
			}
			if (coll.isEmpty()){
				return false;
			}
			if (actual==null){
				actual=new LinkedList();
			}
			if (coll.size()!=actual.size()){
				return false;				
			}
		}
		
		//only returns true if in all loops the same number of relations are specified
		return true;
	}

}
/*
$Log: ListRelationEditor.java,v $
Revision 1.5  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.4  2006/06/13 13:30:42  euler
Updates

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
