/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;

/**
 * @author Daniel Hakenjos
 * @version $Id: ListOutputEditor.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public class ListOutputEditor extends ListSelectEditor{


	public ListOutputEditor(MiningMartApplication app, Step step, OpParam opParam){
		super(app,step,opParam);
	}
	
	public void init(){
		super.init();

		Collection coll=getParameterCollection();
		if (coll==null){
			this.selected_data=new String[0];
		}else{
			Iterator iter=coll.iterator();
			selected_data=new String[coll.size()];
			int i=0;
			while(iter.hasNext()){
				selected_data[i]=(String) iter.next();
				i++;
			}
		}

		setDataItems(selected_data);
	}

	/**
	 * @see javax.swing.CellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		if (equalsOutputSelectedData()) {

		} else {
			LinkedList list = new LinkedList();
			for (int i = 0; i < selected_data.length; i++) {
				list.add(selected_data[i]);
			}
			this.setParameterCollection(list);
			this.fireStateChanged();
		}
		return super.stopCellEditing();
	}


	
	/**
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setLoopNumber(int)
	 */
	public void setLoopNumber(int loopnumber) {
		super.setLoopNumber(loopnumber);
/*		boolean loopable=true;
		try{
			loopable=opParam.isLoopable();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			loopable=true;
		}
		
		if ((loopnumber>1)&&(!loopable)){
			this.button.setEnabled(false);
		}else{
			this.button.setEnabled(true);
		}*/
	}
	
	

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		ListSelectDialog dialog=new ListSelectDialog(app,Resource.getString("STEPSETTINGS_TITLE_LIST_OUTPUT"),Resource.getString("STEPSETTINGS_TITLE_SELECT_OUTPUT"),selected_data,opParam.getMinArg(),opParam.getMaxArg());
		if (dialog.getExitAction()==ListSelectDialog.OK){
			selected_data=dialog.getSelectedDataItems();
			this.setDataItems(selected_data);
			
			LinkedList list=new LinkedList();
			for(int i=0;i<selected_data.length;i++){
				list.add(selected_data[i]);
			}
			
			setParameterCollection(list);
			this.fireStateChanged();
		}
		this.stopCellEditing();
	}
	
	private boolean equalsOutputSelectedData(){
		Collection coll=getParameterCollection();
		if (coll.size()!=selected_data.length)
			return false;
			
		Iterator iter=coll.iterator();
		String out;
		for (int i=0;i<selected_data.length;i++){
			out=(String) iter.next();
			if (!out.equals(selected_data[i])){
				return false;
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		//die Ueberpruefung ist hier zu kompliziert, deshlab lieber gleich neu anlegen
		return false;
	}


}
/*
 * Historie
 * --------
 *
 * $Log: ListOutputEditor.java,v $
 * Revision 1.4  2006/09/27 14:59:58  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:13  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:14  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.8  2005/08/16 08:41:44  hakenjos
*** empty log message ***

Revision 1.7  2005/07/15 13:47:01  hakenjos
*** empty log message ***

Revision 1.6  2005/07/13 13:22:52  euler
Bugfixes

Revision 1.5  2005/07/12 13:49:12  hakenjos
*** empty log message ***

Revision 1.4  2005/07/12 11:17:15  hakenjos
Fixed bug: actionPerformed() ->setParameterCollection() with selected_data

Revision 1.3  2005/07/12 10:19:09  hakenjos
Implemented method: existsOutput() -> boolean

Revision 1.2  2005/07/11 14:28:30  hakenjos
*** empty log message ***

Revision 1.1  2005/07/11 14:18:26  hakenjos
*** empty log message ***

 */
