/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.IteratorList;
import edu.udo.cs.miningmart.gui.application.IteratorListener;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * Shows the groups of a step.
 * @author Daniel Hakenjos
 * @version $Id: GroupsDialog.java,v 1.4 2006/09/27 14:59:58 euler Exp $
 */
public class GroupsDialog extends JDialog implements ActionListener, IteratorListener{

	private MiningMartApplication app;
	
	private Step step;
	
	private Collection editor;
	
	private JButton closebutton;

	private IteratorList iterlist;
	
	private JTabbedPane tabbedpane;
	
	private int nrOfLoops;

	private int loopnumber;
	
	private Vector grouppanel;
	
	/**
	 * Shows a Dialog of all coordinated parameter arrays
	 * @param editor a <code>Collection</code> of <code>ParameterEditor</code>.
	 * @see edu.udo.cs.miningmart.m4.Operator#getCoordinatedParameterArrays()
	 */
	public GroupsDialog(MiningMartApplication app, Step step, Collection editor){
		super(app,Resource.getString("STEPSETTINGS_GROUPS_TITLE")+ " "+step.getName(),true);
		this.app=app;
		this.step=step;
		this.editor=editor;
		this.nrOfLoops=step.getLoopCount();
		this.loopnumber=1;
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		this.pack();

		setSize(600, 300);

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);
	}
	
	private void initComponents(){
		JPanel mainpanel=new JPanel(new BorderLayout(5,5));
		this.getContentPane().add(mainpanel);
		
		JPanel northpanel=new JPanel(new BorderLayout(5,5));
		northpanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		mainpanel.add(northpanel,BorderLayout.NORTH);
		
		JLabel steplabel=new JLabel();
		steplabel.setText(step.getName());
		steplabel.getFont().deriveFont(Font.BOLD,15);
		steplabel.setHorizontalAlignment(SwingConstants.LEFT);	
		northpanel.add(steplabel,BorderLayout.WEST);
		
		if ((step.getTheOperator().isLoopable())&&(nrOfLoops>1)){
			
			JPanel looppanel=new JPanel(new FlowLayout(FlowLayout.RIGHT));
			northpanel.add(looppanel,BorderLayout.EAST);
			
			JLabel looplabel=new JLabel();
			looplabel.setText(Resource.getString("SHOW_LOOP_NUMBER"));
			looplabel.getFont().deriveFont(Font.BOLD,15);
			looplabel.setHorizontalAlignment(SwingConstants.LEFT);	
			looppanel.add(looplabel);
			
			String[] data=new String[nrOfLoops];
			for(int i=1;i<=nrOfLoops;i++){
				data[i-1]=Integer.toString(i);
			}
			iterlist=new IteratorList(data);
			iterlist.addIteratorListener(this);
			looppanel.add(iterlist);
		}
		
		JPanel buttonpanel=new JPanel(new BorderLayout(5,5));
		mainpanel.add(buttonpanel,BorderLayout.SOUTH);
		
		closebutton = new JButton(Resource.getString("STEPSETTINGS_CLOSE"));
		closebutton.addActionListener(this);
		buttonpanel.add(closebutton, BorderLayout.EAST);
		
		tabbedpane=new JTabbedPane();
		mainpanel.add(tabbedpane,BorderLayout.CENTER);
		
		createGroupPanel();
		for(int i=0;i<grouppanel.size();i++){
			tabbedpane.addTab(Resource.getString("STEPSETTINGS_GROUP")+" "+Integer.toString(i+1),(JPanel) grouppanel.get(i));
		}
		
	}
	
	private void createGroupPanel(){
		grouppanel=new Vector();
		Collection coll=null;
		try{
			coll=step.getTheOperator().getCoordinatedParameterArrays();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			return;
		}
		Iterator iter=coll.iterator();
		JPanel panel;
		Collection coll2;
		while (iter.hasNext()){
			coll2=(Collection) iter.next();
			panel=createGroupPanel(coll2);
			grouppanel.add(panel);
		}
	}


	private JPanel createGroupPanel(Collection opParams){
		if (opParams==null){
//			System.out.println("opParams null");
			JPanel p=new JPanel();
			p.setBackground(Color.YELLOW);
			return p;
		}

		JPanel panel=new JPanel();
//		panel.setLayout(new GridLayout(1,opParams.size(),5,5));
		panel.setLayout(new BorderLayout());
		panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));


		String[][] tabledata;
		String[] colnames;
		
		colnames=new String[opParams.size()];

		Iterator iter=opParams.iterator();
		OpParam opParam;
		int rows=0;
		int col=0;
		while (iter.hasNext()){
			opParam=(OpParam) iter.next();
			colnames[col]=opParam.getName();
			rows=Math.max(rows,getData(opParam).length);
			col++;
		}

		tabledata=new String[rows][opParams.size()];
		for(int i=0;i<rows;i++){
			for(int j=0;j<opParams.size();j++){
				tabledata[i][j]=new String("");
			}
		}

		iter=opParams.iterator();
		String[] data;
		col=0;
		while (iter.hasNext()){
			opParam=(OpParam) iter.next();
			data=getData(opParam);	
			for(int r=0;r<data.length;r++){
				tabledata[r][col]=new String(data[r]);
			}
			col++;
		}
		
		JTable table=new JTable(tabledata,colnames);
		table.setDefaultRenderer(Object.class,new GroupTableCellRenderer());
		JScrollPane scrollpane=new JScrollPane(table);
		panel.add(scrollpane);

		return panel;
	}
	
	private String[] getData(OpParam opParam){

		Iterator iter=editor.iterator();
		ParameterEditor peditor=null;
		OpParam param;

		boolean found=false;
		while ((!found)&&(iter.hasNext())){
			peditor=(ParameterEditor) iter.next();
			param=peditor.getTheOpParam();
			if (param.getName().equals(opParam.getName())){
				found=true;
			}
		}
		
		String[] data=new String[0];
		
		if (!found){
			return data;
		}
		
		if ((peditor!=null)&&(peditor instanceof ListSelectEditor)){
			ListSelectEditor listeditor=(ListSelectEditor) peditor;
			return listeditor.getDataItems();
		}
		else{
			return data;
		}
	}	
	

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		dispose();
	}
	
	

	/**
	 * @see edu.udo.cs.miningmart.gui.application.IteratorListener#iterationChanged(String, int)
	 */
	public void iterationChanged(String data, int index) {
		
	}

}
/*
$Log: GroupsDialog.java,v $
Revision 1.4  2006/09/27 14:59:58  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
