/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.model;

import java.util.Collection;
import java.util.Iterator;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Projection;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Daniel Hakenjos
 * @version $Id: MiningMartProjection.java,v 1.6 2006/09/27 15:00:00 euler Exp $
 */
public class MiningMartProjection extends ModelConnectionElement{


	private Projection projection;
	
	private MiningMartApplication app;
	
	private boolean deleteInDatabase=true;

	public MiningMartProjection(){
		super();
	}

	/**
	 * Constructs new <code>MiningMartRelation</code> with the given parameters.
	 * @param name the name of the output- and input-concept
	 */
	public MiningMartProjection(MiningMartApplication app,Projection projection, String name, Model model,ModelFigureElement start, ModelFigureElement end) {
		super(name, model);
		
		this.projection=projection;
		this.setStart(start);
		this.setEnd(end);
		this.app=app;
	}
	
	
	/**
	 *Sets the <code>MiningMartApplication</code>.
	 */
	public void setMMartApplication(MiningMartApplication app){
		if (this.app==null){
			this.app=app;
		}
	}

	/**
	 *Gets the <code>MiningMartApplication</code>.
	 */
	public MiningMartApplication getMMartApplication(){
		return app;
	}

	/**
	 * Sets the flag that this object could be deleted in the database.
	 */    
	public void setDeleteInDatabase(boolean bool){
		this.deleteInDatabase=bool;
	}
    
	/**
	 * Gets the flag indicating that this obkect can be deleted in the database.
	 */
	public boolean canDeleteInDatabase() {
		return this.deleteInDatabase;
	}
	
	public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
		Concept from=((MiningMartConcept) start).getConcept();
		Concept to=((MiningMartConcept) end).getConcept();

		try {
			Collection fromproj=from.getProjectionsAsFromConcept();
			Iterator iter=fromproj.iterator();
			
			Projection proj;
			while(iter.hasNext()){
				proj=(Projection) iter.next();
				if (proj.getToConcept().equals(to))
					return false;
			}
		} catch (M4Exception error) {
			return false;
		}
				
		return true;
	}

	/**
	 *Gets the start-class.
	 */
	protected Class getStartClass() {
		return ModelFigureElement.class;
	}

		/**
		 *Gets the start-name.
		 */
	protected String getStartName() {
		return "outgoing";
	}

	/**
	 *Gets the end class.
	 */
	protected Class getEndClass() {
		return ModelFigureElement.class;
	}

		/**
		 *Gets the end name.
		 */
	protected String getEndName() {
		return "incoming";
	}

    
	public String toString() {
		return getName() + ": " + getType();
	}

	public boolean canDestroy() {
		if (app.getViewMode()==Application.VIEWER){
			return false;
		}
		return true;
	}

	public String getType() {
		return Resource.getString("PROJECTION");
	}
    
	/**
	 * Destroys this <code>MiningMartRelation</code> and deletes the <code>Relation</code>.
	 * @see org.musoft.limo.model.ModelElement#destroy()
	 */
	public void destroy() {
		if (app.getViewMode()==Application.VIEWER){
			//Im viewer-mode darf nicht zerstoert werden
			return;
		}

		super.destroy();
		for (int i = 0; i < getListenerCount(); i++) {
			getListener(i).onDestroy(this);
		}

		if (canDeleteInDatabase()){
			try{
				if (this.projection.isWaitingForDelete()) {
					return;
				}
				Concept from = this.projection.getFromConcept();
				Concept to = this.projection.getToConcept();
				String projectionDescription = "from ";
				if (from != null) {
					projectionDescription += from.getName();
				}
				else {
					projectionDescription += " unknown concept ";
				}
				projectionDescription += " to ";
				if (to != null) {
					projectionDescription += to.getName();
				}
				else {
					projectionDescription += " unknown concept ";
				}
				this.projection.deleteSoon();
				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("DELETED_PROJECTION")+" "+projectionDescription);
			}catch(M4Exception error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
		}
	}
	
	

	/**
	 * @see org.musoft.limo.model.ModelElement#canSetName(String)
	 */
	public boolean canSetName(String name) {
		return false;
	}

	public Projection getProjection(){
		return projection;
	}

	
	/**
	 * If the description of this <code>MiningMartRelation</code> changed then set the documentation of the underlying <code>Relation</code>.
	 * @see org.musoft.limo.model.ModelElement#primitiveAttributeChanged(ModelPrimitiveAttribute)
	 */
	public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
		super.primitiveAttributeChanged(mpa);
		
		try{
		if ((mpa.getName().equals("notes"))&&(projection!=null)){
			
			projection.setDocumentation(mpa.getString());
		}
		
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}
	

}
/*
 * Historie
 * --------
 *
 * $Log: MiningMartProjection.java,v $
 * Revision 1.6  2006/09/27 15:00:00  euler
 * New version 1.1
 *
 * Revision 1.5  2006/06/20 09:03:22  euler
 * Bugfixes
 *
 * Revision 1.4  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/03 10:59:39  hakenjos
 * Relations and Projections have no name!
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.3  2005/12/15 09:15:55  hakenjos
*** empty log message ***

Revision 1.2  2005/12/06 08:53:14  hakenjos
*** empty log message ***

Revision 1.1  2005/08/16 08:41:44  hakenjos
*** empty log message ***
 */
