/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.model;

import java.awt.Point;
import java.awt.Rectangle;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A wrapper for the <code>BaseAttribute</code>.
 * @author Daniel Hakenjos
 * @version $Id: MiningMartBaseAttribute.java,v 1.5 2006/09/27 15:00:00 euler Exp $
 */
public class MiningMartBaseAttribute extends MiningMartModelFigureElement{

	private BaseAttribute baseattribute;

	private MiningMartApplication app;
	
	private boolean deleteInDatabase=true;

	/**
	 * Creates a new <code>MiningMartBaseAttribute</code> with the given parameters.
	 */
	public MiningMartBaseAttribute(MiningMartApplication app,BaseAttribute baseattribute,ModelFigureElement parent,Point position, Rectangle bounds) {
		super(baseattribute.getName(), bounds, parent);
		this.baseattribute=baseattribute;
		this.app=app;
		this.setPosition(position);

		addAttribute(new ModelPrimitiveAttribute(this,"Type",ModelAttribute.ACCESS_READ, String.class));
		addAttribute(new ModelAssociationEnd(this, "incoming", ModelAttribute.ACCESS_READWRITE, true, StepTransition.class, "end"));
		addAttribute(new ModelAssociationEnd(this, "outgoing", ModelAttribute.ACCESS_READWRITE, true, StepTransition.class, "start"));
		try{
			((ModelPrimitiveAttribute)getAttribute("notes")).setString(baseattribute.getDocumentation());
		}catch(M4Exception error){
		}        
        
		((ModelPrimitiveAttribute)getAttribute("Type")).setString(baseattribute.getType());
		((ModelPrimitiveAttribute)getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Resource.getColor("CONCEPT_NOTSELECTED_COLOR"));
		((ModelPrimitiveAttribute)getAttribute(Resource.getString("ATTR_COLOR"))).setAccess(ModelAttribute.ACCESS_READ);
	}

	/**
	 *Gets the <code>MiningMartApplication</code>.
	 */
	public MiningMartApplication getMMartApplication(){
		return app;
	}


	public boolean canSetParent(ModelFigureElement parent) {
		return true;
	}
	
	public String getType(){
		return Resource.getString("BASEATTRIBUTE");
	}

        
	/**
	 *Gets the name of the <code>MiningMartBaseAttribute</code>.
	 *@return returns the name of the <code>BaseAttribute</code>
	 *@see edu.udo.cs.miningmart.m4.BaseAttribute#getName()
	 */
	public String getName(){
		if (baseattribute!=null)
			return this.baseattribute.getName();
		return "";
	}

		/**
		 *Sets the name of the <code>MiningMartBaseAttribute</code>.
		 *It means it sets the name of the <code>BaseAttribute</code>.
		 *@see edu.udo.cs.miningmart.m4.BaseAttribute#setName(String)
		 */
	public void setName(String name){
		if (baseattribute!=null)
			this.baseattribute.setName(name);
		super.setName(name);
	}
    
	/**
	 * Gets the <code>BaseAttribute</code>.
	 */
	public BaseAttribute getBaseAttribute(){
		return baseattribute;
	}
	
	M4Data getAttachedM4Object() {
		return this.getBaseAttribute();
	}

	/**
	 * If the description of this <code>MiningMartBaseAttribute</code> changed then set the documentation of the underlying <code>BaseAttribute</code>.
	 * @see org.musoft.limo.model.ModelElement#primitiveAttributeChanged(ModelPrimitiveAttribute)
	 */
	public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
		super.primitiveAttributeChanged(mpa);
		if ((mpa.getName().equals(Resource.getString("ATTR_NAME")))&&(baseattribute!=null)){
			setName(mpa.getString());
		}
	}

	
	/**
	 *Sets the bounds of the <code>MiningMartBaseAttribute</code>.
	 * The location of the underlying <code>BaseAttribute</code> is set to the location of the bounds.
	 * @see org.musoft.limo.model.ModelFigureElement#setBounds(Rectangle)
	 */
	public void setBounds(Rectangle bounds) {
		super.setBounds(bounds);

		if (bounds==null){
			return;
		}
		
		if (baseattribute==null){
			return;
		}

/*		try{
			baseattribute.setPoint(bounds.getLocation());
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}*/
	}

	/**
	 *Sets the position of this <code>MiningMartConcept</code>.
	 *The position of the underlying <code>Concept</code> also changes.
	 */
	public void setPosition(Point p){
		super.setPosition(p);
/*		try{
			baseattribute.setPoint(p);
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
*/			
	}
	

	public boolean canDestroy() {
		if (app.getViewMode()==Application.VIEWER){
			return false;
		}
		return true;
	}
	

	/**
	 *Destroys the <code>MiningMartConcept</code> and deletes the underlying <code>Concept</code>.
	 * @see org.musoft.limo.model.ModelElement#destroy()
	 */
	public void destroy() {
		if (app.getViewMode()==Application.VIEWER){
			//Im viewer-mode darf nicht zerstoert werden
			return;
		}

		MiningMartRelation relation;
/*		for (int i=this.getParent().getConnectionCount()-1;i>=0;i--){
			relation=(MiningMartRelation) this.getParent().
			relation=null;
			trans=(StepTransition) parentchain.getConnection(i);
			if ((trans.getStart().getName().equals(getName()))||(trans.getEnd().getName().equals(getName()))){
				relation.destroy();
			}
		}
*/
		super.destroy();

		for (int i = 0; i < getListenerCount(); i++) {
			getListener(i).onDestroy(this);
		}

		
		if (this.canDeleteInDatabase()){		
			try{
				String baseattribname=baseattribute.getName();
				this.baseattribute.deleteSoon();
//				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("DELETED_BASEATTRIBUTE")+" "+baseattribname);
			}catch(M4Exception error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
		}
	}


	/**
	 * Sets the flag that this object could be deleted in the database.
	 */    
	public void setDeleteInDatabase(boolean bool){
		this.deleteInDatabase=bool;
	}
	    
	/**
	 * Gets the flag indicating that this obkect can be deleted in the database.
	 */
	public boolean canDeleteInDatabase(){
		return this.deleteInDatabase;
	}


}
/*
 * Historie
 * --------
 *
 * $Log: MiningMartBaseAttribute.java,v $
 * Revision 1.5  2006/09/27 15:00:00  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/02 16:49:59  euler
 * Many bugfixes
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.5  2005/12/15 09:15:55  hakenjos
*** empty log message ***

Revision 1.4  2005/10/11 07:57:56  hakenjos
*** empty log message ***

Revision 1.3  2005/07/20 14:00:06  hakenjos
*** empty log message ***

Revision 1.2  2005/07/19 12:18:06  hakenjos
*** empty log message ***

Revision 1.1  2005/07/07 07:51:36  hakenjos
*** empty log message ***

 */
