/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

import javax.swing.ImageIcon;

import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A <code>ModelFigure</code> for the <code>MiningMartStep</code>.
 * @author Daniel Hakenjos
 * @version $Id: StepFigure.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class StepFigure extends ModelFigure implements ImageObserver{

	public static boolean NO_DIRTYING = false;
	
	private String   filename;

	private transient Image bound;
	private transient Image image;
	
	private Rectangle fDisplayBox;
	private Point origin,corner;
	private String op_name,name;
	
	/**
	 * Constructs new <code>StepFigure</code>.
	 */
	public StepFigure(ModelFigureElement element, ModelDrawing drawing){
		super(element,drawing);

		this.op_name=((ModelPrimitiveAttribute) element.getAttribute("Operator")).getString();
		this.name=element.getName();
		
		bound=getStepBoundImage();
		image=getStepFigureImage();
		
		filename=getStepFigureFileName();

		// PresentationFigure setzen
		setPresentFigure();
		
		this.setSizeable(false);

		// Label positionieren und initiallisieren		
		setLabelPosition(LABEL_OUTSIDE | LABEL_SOUTH);
		setLabel(getElement().getName());
		
		
		
	}
	
	@Override
	public void bringToFront() {
		NO_DIRTYING = true;
		super.bringToFront();
		NO_DIRTYING = false;
	}
	
        /**
         *Gets the <code>MiningMartStep</code>.
         */
	public MiningMartStep getMiningMartStep(){
		return (MiningMartStep) getElement();
	}
	
        /**
         *Gets the filename of the step-figure.
         */
	public String getStepFigureFileName(){
		String f=Resource.getString("ICON_OP_"+op_name.toUpperCase());

		if (f.equals("ICON_OP_"+op_name.toUpperCase())){
			f=Resource.getString("ICON_OP_GENERICOPERATOR");
		}
		
		
		return (getClass().getResource(f)).getFile();
	}

        /**
         *Gets the iamge of the <code>StepFigure</code>.
         */
	public Image getStepFigureImage(){

		String img=null;
		if (op_name!=null)
			img=Resource.getString("ICON_OP_"+op_name.toUpperCase());
		
		if ((img!=null)&&(img.equals("ICON_OP_"+op_name.toUpperCase()))){
			img=Resource.getString("ICON_OP_GENERICOPERATOR");
		}
		
		return (new ImageIcon(this.getClass().getResource(img))).getImage();
	}
	
	private Image getStepBoundImage(){
		String img=null;

		img=Resource.getString("ICON_OP_BOUND");
		
		if ((img!=null)&&(img.equals("ICON_OP_BOUND"))){
			img=Resource.getString("ICON_OP_GENERICOPERATOR");
		}
		
		return (new ImageIcon(this.getClass().getResource(img))).getImage();
	}

	private void setPresentFigure(){
		Rectangle bounds 	= this.getElement().getBounds();
		origin 		= bounds.getLocation();
		corner 		= new Point(origin.x + bounds.width, origin.y + bounds.height);	

		basicDisplayBox(origin, corner);
		//new Point(origin.x + Math.max(image.getWidth(this),name.length()*8), origin.y + image.getHeight(this)+100));


		//present 			= new StepImageFigure(image,filename,origin,"GenericOperator");
		
		RectangleFigure rf=new RectangleFigure(origin, corner);//new Point(origin.x + Math.max(image.getWidth(this),name.length()*8), origin.y + image.getHeight(this)+10));
		setPresentationFigure(rf);
	}	

	public void basicDisplayBox(Point origin, Point corner) {				
		super.basicDisplayBox(origin, corner);
	}

        /**
         *If the <code>StepFigure</code> was moved then the position of the <code>Step</code> also changes.
         */
	public void moveBy(int dx, int dy) {
		if (dx == 0 && dy == 0)
			return;
		super.moveBy(dx,dy);
		origin=new Point(origin.x+dx,origin.y+dy);
		corner=new Point(corner.x+dx,corner.y+dy);

		MiningMartStep step=((MiningMartStep) getElement());
		step.setBounds(new Rectangle(origin.x,origin.y,35,35));
		try{
			step.getStep().setPoint(origin);
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR, error.getMessage(),error);
		}

	}

        /**
         *Draws the image of the <code>StepFigure</code>.
         */
	public void draw(Graphics g) {
		super.draw(g);

		if (image == null) {
			image = Iconkit.instance().getImage(filename);
		}

		g.setColor(Resource.getColor("DRAWING_VIEW_BACKGROUNDCOLOR"));
		g.fillRect(origin.x, origin.y, 35,35);
		
		g.setColor((Color) getElement().getAttribute(Resource.getString("ATTR_COLOR")).getValue());
		g.fillRect(origin.x+3, origin.y+3, 29,29);

		if (bound!=null){
			g.drawImage(bound, origin.x, origin.y, 35,35, this);
		}

		if (image != null) {
			//g.drawImage(image, origin.x, origin.y, image.getWidth(this), image.getHeight(this), this);
			g.drawImage(image, origin.x+5, origin.y+5, 25,25, this);
		}

		g.setColor(Color.BLACK);
		try{
			Step step=((MiningMartStep) getElement()).getStep();
			if (step.hasPredecessorOutsideChain()){
				g.drawLine(origin.x-20,origin.y+15,origin.x,origin.y+15);
				Polygon polygon=new Polygon();
				polygon.addPoint(origin.x,origin.y+15);
				polygon.addPoint(origin.x-8,origin.y+12);
				polygon.addPoint(origin.x-8,origin.y+18);
				g.fillPolygon(polygon);
			}
			if (step.hasSuccessorOutsideChain()){
				g.drawLine(origin.x+35,origin.y+15,origin.x+55,origin.y+15);
				Polygon polygon=new Polygon();
				polygon.addPoint(origin.x+55,origin.y+15);
				polygon.addPoint(origin.x+47,origin.y+12);
				polygon.addPoint(origin.x+47,origin.y+18);
				g.fillPolygon(polygon);
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR, error.getMessage(),error);
		}
	}
	
	   /**
	* Handles asynchroneous image updates. 
	*/
	public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
		if ((flags & (FRAMEBITS|ALLBITS)) != 0) {
			invalidate();
			if (listener() != null) {
				listener().figureRequestUpdate(new FigureChangeEvent(this));
			}
		}
		return (flags & (ALLBITS|ABORT)) == 0;
	}
	
        /**
         *Sets the label.
         */
	public void onSetName(ModelElement sender){
			setLabel(getElement().getName());
			invalidate();
	}
	
    public void onSetAttribute(ModelElement sender, ModelPrimitiveAttribute mpa) {
		super.onSetAttribute(sender,mpa);
		String s = mpa.getName();
		if (s.equals("Operator")){
			op_name=((ModelPrimitiveAttribute) getElement().getAttribute("Operator")).getString();
		}
    }
    
    
}
/*
$Log: StepFigure.java,v $
Revision 1.4  2006/09/27 15:00:03  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:17  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:16  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:33  hakenjos
Initial version!

*/
