/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.figures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

import org.jhotdraw.figures.ArrowTip;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.model.ModelConnectionElement;

import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.m4.Relation;

/**
 * A <code>ModelConnection</code> for the <code>Relation</code>.
 * @author Daniel Hakenjos
 * @version $Id: RelationFigure.java,v 1.5 2006/09/27 15:00:03 euler Exp $
 */
public class RelationFigure extends ModelConnection{


	/**
	 * Constructor for RelationFigure.
	 */
	public RelationFigure(ModelDrawing drawing, ModelConnectionElement element) {
		super(drawing, element);
		
		Relation relation=((MiningMartRelation) element).getRelation();
		if (relation.isOneToManyRelation()){
			setEndDecoration(new ArrowTip(0.7, 20, 5));
		}else{
			setStartDecoration(new ArrowTip(0.7, 20, 5));
			setEndDecoration(new ArrowTip(0.7, 20, 5));
		}

		setLabel(element.getName());
		setLabelPosition(LABEL_CENTER);
	}

   /**
	*Gets the <code>MiningMastRelation</code>.
	*/
	public MiningMartRelation getMiningMartRelation(){
		return (MiningMartRelation) getElement();
	}
	
	/* (non-Javadoc)
	 * normale Linie
	 * @see org.jhotdraw.figures.PolyLineFigure#drawLine(java.awt.Graphics, int, int, int, int)
	 */
	protected void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
		Stroke saved = ((Graphics2D)g).getStroke();
		((Graphics2D)g).setStroke(new BasicStroke(2));
		g.setColor(Color.BLACK);
		g.drawLine(x1,y1,x2,y2);
		((Graphics2D)g).setStroke(saved);
	}

}
/*
 * Historie
 * --------
 *
 * $Log: RelationFigure.java,v $
 * Revision 1.5  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/03 11:02:15  hakenjos
 * A one-to-many Relation has only one arrow.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.4  2005/12/06 08:53:14  hakenjos
*** empty log message ***

Revision 1.3  2005/08/16 08:41:44  hakenjos
*** empty log message ***

Revision 1.2  2005/07/19 14:20:55  hakenjos
*** empty log message ***

Revision 1.1  2005/06/22 08:31:39  hakenjos
Initial version!

*/
