/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.figures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

import org.jhotdraw.figures.RectangleFigure;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;

import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;

/**
 * @author Daniel Hakenjos
 * @version $Id: FeatureFigure.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class FeatureFigure extends ModelFigure{
	
	private boolean baseattribute;

	/**
	 * Constructor for FeatureFigure.
	 */
	public FeatureFigure(MiningMartBaseAttribute element, ModelDrawing drawing) {
		this((ModelFigureElement) element, drawing);

		baseattribute=true;
	}
	
	/**
	 * Constructor for FeatureFigure.
	 */
	public FeatureFigure(MiningMartMultiColumnFeature element, ModelDrawing drawing) {
		this((ModelFigureElement) element, drawing);

		baseattribute=false;
	}


	private FeatureFigure(ModelFigureElement element, ModelDrawing drawing){
		super(element,drawing);
		
		Rectangle bounds 	= this.getElement().getBounds();
		Point origin 			= bounds.getLocation();
		Point corner 			= new Point(origin.x + bounds.width, origin.y + bounds.height);	

		setPresentationFigure(new RectangleFigure(origin, corner));			
		
		// neue gestrichelte Linie
		Rectangle rect = element.getBounds();
		Point start = new Point(rect.x, rect.y + rect.height - 1);
		Point end   = new Point(rect.x + rect.width, rect.y + rect.height - 1);

		setAttribute("FrameColor",element.getAttribute(Resource.getString("ATTR_COLOR")).getValue()); 

		// Label positionieren und initiallisieren		
		setLabelPosition(LABEL_INSIDE | LABEL_WEST);
		if (element instanceof MiningMartBaseAttribute){
			setLabel("BA: "+getElement().getName());
		}else{
			setLabel("MCF: "+getElement().getName());
		}
		
		this.setSizeable(false);

	}

	/**
	 * Gets the MiningMartBaseAttribute.
	 */	
	public MiningMartBaseAttribute getMiningMartBaseAttribute(){
		if (baseattribute){
			return (MiningMartBaseAttribute) getElement();
		}
		return null;
	}
	
	/**
	 * Gets the MiningMartMultiColumnFeature.
	 */	
	public MiningMartMultiColumnFeature getMiningMartMultiColumnFeature(){
		if (!baseattribute){
			return (MiningMartMultiColumnFeature) getElement();
		}
		return null;
	}

	/**
	 * Sets the name of the label.
	 */
	public void onSetName(ModelElement sender) {
		if (sender == getElement()) {
			if (baseattribute){
				setLabel("BA: "+sender.getName());
			}else{
				setLabel("MCF: "+sender.getName());
			}
		}
	}

	public void moveBy(int dx, int dy) {
	}

	public void draw(Graphics g) {
		super.draw(g);

		Stroke saved = ((Graphics2D)g).getStroke();
		((Graphics2D)g).setStroke(new BasicStroke(1, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 0, new float[]{1, 5}, 0));
		Rectangle rect = displayBox();
		g.setColor(Color.BLACK);
		g.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
		((Graphics2D)g).setStroke(saved);
	}

	
}
/*
 * Historie
 * --------
 *
 * $Log: FeatureFigure.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.2  2005/10/11 07:57:56  hakenjos
*** empty log message ***

Revision 1.1  2005/07/20 14:00:06  hakenjos
*** empty log message ***
 
 */
