/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;

import javax.swing.ImageIcon;

import org.jhotdraw.figures.ImageFigure;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelElement;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;


/**
 * A <code>ModelFigure</code> for the <code>MiningMartChauin</code>.
 * @author Daniel Hakenjos
 * @version $Id: ChainFigure.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class ChainFigure extends ModelFigure{

	private ImageFigure present;
	
	private Point origin;

	/**
	 * Constructor for ChainFigure.
	 */
	public ChainFigure(Model element, ModelDrawing drawing){
		
		super(element,drawing);
				
		Image img=(new ImageIcon(this.getClass().getResource("/images/Operators/chain1.png"))).getImage();
		
		String filename=(getClass().getResource("/images/Operators/chain1.png")).getFile();

		// PresentationFigure setzen
		//Rectangle bounds 	= this.getElement().getBounds();
		origin 		= ((MiningMartChain) element).getOrigin();
		//bounds.getLocation();
		
		present 			= new ImageFigure(img,filename,origin);
		
		
		this.setPresentationFigure(present);

		// Label positionieren und initiallisieren		
		setLabelPosition(LABEL_OUTSIDE | LABEL_SOUTH);
		setLabel(element.getName());

	}

        /**
         *Gets the <code>MiningMartChain</code>.
         */
	public MiningMartChain getMiningMartChain(){
		return (MiningMartChain) getElement();
	}

        /**
         *Sets the label.
         */
	public void onSetName(ModelElement sender){
			setLabel(getElement().getName());
			invalidate();
	}

        /**
         *If the <code>ChainFigure</code> was moved then the position of the <code>Chain</code> also changes.
         */
	public void moveBy(int dx, int dy) {
		if (dx == 0 && dy == 0)
			return;
		super.moveBy(dx,dy);
		origin=new Point(origin.x+dx,origin.y+dy);

		try{
			if (getElement() instanceof MiningMartChain){
				MiningMartChain c=((MiningMartChain) getElement());
				c.getChain().setPoint(origin);
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}

	}
	
	@Override
	public void bringToFront() {
		StepFigure.NO_DIRTYING = true;
		super.bringToFront();
		StepFigure.NO_DIRTYING = false;
	}


	/**
	 *Draws the image of the <code>StepFigure</code>.
	 */
	public void draw(Graphics g) {
		super.draw(g);
	
		g.setColor(Color.BLACK);
		try{
			if (((MiningMartChain) getElement()).getChain().hasPredecessorOutside()){
				g.drawLine(origin.x-20,origin.y+15,origin.x,origin.y+15);
				Polygon polygon=new Polygon();
				polygon.addPoint(origin.x,origin.y+15);
				polygon.addPoint(origin.x-8,origin.y+12);
				polygon.addPoint(origin.x-8,origin.y+18);
				g.fillPolygon(polygon);
			}
			if (((MiningMartChain) getElement()).getChain().hasSuccessorOutside()){
				g.drawLine(origin.x+35,origin.y+15,origin.x+55,origin.y+15);
				Polygon polygon=new Polygon();
				polygon.addPoint(origin.x+55,origin.y+15);
				polygon.addPoint(origin.x+47,origin.y+12);
				polygon.addPoint(origin.x+47,origin.y+18);
				g.fillPolygon(polygon);
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR, error.getMessage(),error);
		}
	}	
	
}

/*
$Log: ChainFigure.java,v $
Revision 1.4  2006/09/27 15:00:03  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:17  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:16  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:33  hakenjos
Initial version!

*/
