/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingConstants;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.Roles;

/**
 * A dialog to create BaseAttributes in great quantities.
 * @author Daniel Hakenjos
 * @version $Id: NewBaseAttributesDialog.java,v 1.4 2006/09/27 15:00:02 euler Exp $
 */
public class NewBaseAttributesDialog extends JDialog implements ActionListener{

	public static final int CANCEL = 0;
	public static final int OK = 1;
	
	private int exitAction;
	
	private MiningMartApplication app;
	
	private JButton ok,cancel;
	
	private JComboBox att_type_box,data_type_box, role_box;
	
	private JTextField numberfield,namefield;
	
	public NewBaseAttributesDialog(MiningMartApplication app){
		super(app,Resource.getString("FEATURE_MULTINEWDIALOG_TITLE"),true);
		this.app=app;

		initComponents();		
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		this.pack();

		setSize(400, 250);

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);
	}
	
	private void initComponents(){
		
		JPanel toppanel=new JPanel();
		toppanel.setLayout(new BorderLayout());
		this.getContentPane().add(toppanel);
		
		//Titel
		JLabel toplabel=new JLabel();
		toplabel.setText(Resource.getString("FEATURE_MULTINEWDIALOG_SUBTITLE"));

		Font opfont=new Font("SansSerif",Font.PLAIN,15);
		toplabel.setFont(opfont);
		toplabel.setForeground(Color.BLUE);
		toplabel.setHorizontalAlignment(SwingConstants.CENTER);	
		toplabel.setBorder(BorderFactory.createEmptyBorder(5,0,0,0));
		toppanel.add(toplabel,BorderLayout.NORTH);

		//Input
		JPanel midpanel=new JPanel();
		midpanel.setLayout(new SpringLayout());
		midpanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		toppanel.add(midpanel,BorderLayout.CENTER);

		JLabel label=new JLabel("Number:");
		numberfield=new JTextField("1");
		midpanel.add(label);
		midpanel.add(numberfield);

		label=new JLabel(Resource.getString("ATTR_NAME")+":");
		namefield=new JTextField(Resource.getString("BASEATTRIBUTE"));
		midpanel.add(label);
		midpanel.add(namefield);

		label=new JLabel(Resource.getString("FEATURE_TYPE")+":");
		Object[] types=new Object[]{BaseAttribute.TYPE_DB,BaseAttribute.TYPE_MINING};
		att_type_box=new JComboBox(types);
		att_type_box.setSelectedIndex(0);
		midpanel.add(label);
		midpanel.add(att_type_box);

		label=new JLabel(Resource.getString("FEATURE_ROLE")+":");
		Object[] roles=new Object[]{Roles.ROLE_PREDICTOR, Roles.ROLE_LABEL, Roles.ROLE_KEY, Roles.ROLE_NOROLE};
		role_box=new JComboBox(roles);
		role_box.setSelectedIndex(0);
		midpanel.add(label);
		midpanel.add(role_box);

		label=new JLabel(Resource.getString("FEATURE_DATATYPE")+":");
		Object[] cdtypes=new Object[ConceptualDatatypes.CDTYPES.length];
		for(int i=0;i<cdtypes.length;i++){
			cdtypes[i]=(Object) ConceptualDatatypes.CDTYPES[i];
		}
		data_type_box=new JComboBox(cdtypes);
		data_type_box.setSelectedIndex(0);
		midpanel.add(label);
		midpanel.add(data_type_box);
		
		//		  Lay out the panel.
		SpringUtilities.makeCompactGrid(midpanel,
										5, 2, //rows, cols
										6, 6,        //initX, initY
										6, 6);       //xPad, yPad
										
		//Buttons
		cancel = new JButton(Resource.getString("CANCEL"));
		ok = new JButton(Resource.getString("OK"));
		ok.setEnabled(true);

		cancel.addActionListener(this);
		ok.addActionListener(this);

		JPanel bottom = new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(ok);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);
		bottom.setBorder(BorderFactory.createEmptyBorder(0,5,5,5));


		toppanel.add(bottom, BorderLayout.SOUTH);	
	}


	/**
	 * Called if one of the buttons was pressed.
	 */
	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();

		if (cmd.equals(Resource.getString("CANCEL"))) {
			exitAction = CANCEL;
			this.dispose();
		}else if (cmd.equals(Resource.getString("OK"))) {
			exitAction = OK;
			this.dispose();
		}

	}

	/**
	 *Gets the action when the dialog was exited.
	 */
	public int getExitAction() {
		return exitAction;
	}
	
	/**
	 * Get the name for the BaseAttributes.
	 */
	public String getName(){
		return namefield.getText();
	}
	
	/**
	 * Gets the number of BaseAttributes.
	 */
	public int getNumberOfBaseAttributes(){
		try{
			return Integer.parseInt(numberfield.getText());
		}catch(NumberFormatException error){
		}
		return 0;
	}
	
	/**
	 * Gets the attribute type.
	 */
	public String getAttributeType(){
		return (String) att_type_box.getSelectedItem();
	}
	
	/**
	 * Gets the conceptual datatype.
	 */
	public String getConceptualDatatype(){
		return (String) data_type_box.getSelectedItem();		
	}
	
	/**
	 * Gets the name of the role.
	 */
	public String getRoleName() {
		return (String) role_box.getSelectedItem();
	}
}
/*
 * Historie
 * --------
 *
 * $Log: NewBaseAttributesDialog.java,v $
 * Revision 1.4  2006/09/27 15:00:02  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:25  hakenjos
 * Initial version!
 *
 */
