/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.m4.Concept;

/**
 * This is a <code>JPanel</code> to display the <code>Feature</code>s of a <code>Concept</code>.
 * 
 * @author Daniel Hakenjos
 * @version $Id: FeaturePanel.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class FeaturePanel extends ConceptPanel implements ActionListener{
	
	private MiningMartApplication app;
	
	private MiningMartConcept mmartconcept;
	
	private JButton multinewBA, newBA,deleteBA, closeButton;
	
	private FeatureTable featuretable;
	
	private boolean baseattributes;
	
	public FeaturePanel(MiningMartApplication app, MiningMartConcept mmartconcept, boolean baseattributes){
		super();
		this.app=app;
		this.mmartconcept=mmartconcept;
		this.baseattributes=baseattributes;
		
		initComponents();
	}
	
	private void initComponents(){
		Border emptyborder=BorderFactory.createEmptyBorder(5,5,5,5);

		setLayout(new BorderLayout(5,5));
		setBorder(emptyborder);		
		
		JPanel buttonpanel=new JPanel();
		buttonpanel.setLayout(new BoxLayout(buttonpanel, BoxLayout.X_AXIS));
		buttonpanel.add(Box.createHorizontalGlue());
		
		newBA=new JButton(Resource.getString("FEATURE_NEW"));
		newBA.addActionListener(this);
		
		multinewBA=new JButton(Resource.getString("FEATURE_MULTINEW"));
		multinewBA.addActionListener(this);

		deleteBA=new JButton(Resource.getString("DELETE"));
		deleteBA.addActionListener(this);

		if (app.getViewMode()==Application.VIEWER){
			newBA.setEnabled(false);
			multinewBA.setEnabled(false);
			deleteBA.setEnabled(false);
		}


		
		closeButton=new JButton(Resource.getString("CLOSE"));
		closeButton.addActionListener(this);
		
		buttonpanel.add(newBA);
		buttonpanel.add(Box.createRigidArea(new Dimension(5, 0)));		
		if (baseattributes){
			buttonpanel.add(multinewBA);
			buttonpanel.add(Box.createRigidArea(new Dimension(5, 0)));		
		}
		buttonpanel.add(deleteBA);
		buttonpanel.add(Box.createRigidArea(new Dimension(15, 0)));		
		buttonpanel.add(closeButton);
		add(buttonpanel,BorderLayout.SOUTH);
		
		JLabel toplabel=new JLabel();
		if (baseattributes){
			toplabel.setText(mmartconcept.getName()+" - "+Resource.getString("BASEATTRIBUTE"));
		}else{
			toplabel.setText(mmartconcept.getName()+" - "+Resource.getString("MCFEATURE"));
		}
		Font opfont=new Font("SansSerif",Font.PLAIN,15);
		toplabel.setFont(opfont);
		toplabel.setForeground(Color.BLUE);
		toplabel.setHorizontalAlignment(SwingConstants.CENTER);	
		add(toplabel,BorderLayout.NORTH);
		toplabel.setBorder(BorderFactory.createEmptyBorder(10,0,10,0));

		if (baseattributes){
			featuretable=new FeatureTable(app,mmartconcept,FeatureTable.BASEATTRIBUTE_MODE);
		}else{
			featuretable=new FeatureTable(app,mmartconcept,FeatureTable.MCFEATURE_MODE);
		}
		
		JPanel descpanel=new JPanel();
		descpanel.setLayout(new BorderLayout(5,5));
		JLabel desclabel=new JLabel(Resource.getString("COMP_NOTEPAD"));
		desclabel.setBorder(BorderFactory.createEmptyBorder(5,0,5,0));
		descpanel.add(desclabel,BorderLayout.NORTH);
		descpanel.add(new JScrollPane(featuretable.getDescriptionArea()),BorderLayout.CENTER);
		descpanel.setBorder(emptyborder);
		
		JSplitPane splitpane=new JSplitPane(JSplitPane.VERTICAL_SPLIT,new JScrollPane(featuretable),descpanel);
		splitpane.setOneTouchExpandable(true);
		splitpane.setResizeWeight(0.5);
		splitpane.setDividerLocation(splitpane.getSize().width - splitpane.getInsets().bottom 
												- splitpane.getDividerSize() - 150);
		
		add(splitpane,BorderLayout.CENTER);
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.concepteditor.ConceptPanel#getConcept()
	 */
	public Concept getConcept() {
		return this.mmartconcept.getConcept();
	}


	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event) {
		if (!(event.getSource() instanceof JButton))
			return;
		JButton source=(JButton) event.getSource();
		
		if (source.getText().equals(closeButton.getText())){
			//Removes the tab
			app.removeComponentFromTab(this);
		}
		if (source.getText().equals(newBA.getText())){
			featuretable.newFeature();
		}
		if (source.getText().equals(multinewBA.getText())){
			featuretable.newBaseAttributes();
		}
		if (source.getText().equals(deleteBA.getText())){
			featuretable.deleteSelectedFeature();
		}
	}
	
	public String toString(){
		if (baseattributes)
			return Resource.getString("BASEATTRIBUTES");
		return Resource.getString("MCFEATURES");
	}

}
/*
 * Historie
 * --------
 *
 * $Log: FeaturePanel.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:25  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.6  2005/12/15 09:15:55  hakenjos
*** empty log message ***

Revision 1.5  2005/11/29 08:00:01  hakenjos
Fixed Resource bug!

Revision 1.4  2005/11/24 10:52:55  hakenjos
Only one ConceptPanel in the Application visible.

Revision 1.3  2005/11/24 10:36:11  hakenjos
*** empty log message ***

Revision 1.2  2005/11/24 09:50:28  hakenjos
Names etc. replaced with resource-access

Revision 1.1  2005/10/18 09:31:54  hakenjos
*** empty log message ***

Revision 1.1  2005/10/11 07:57:56  hakenjos
*** empty log message ***

 */
