/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Roles;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * This is an editor and renderer for <code>BaseAttribute</code>s in the <code>FeatureTable</code>.
 * @author Daniel Hakenjos
 * @version $Id: BaseAttributeEditor.java,v 1.5 2006/09/27 15:00:02 euler Exp $
 */
public class BaseAttributeEditor extends DefaultCellEditor implements TableCellRenderer {

	public static final int NAME_EDITOR 					= 0;
	
	public static final int ATTRIBUTE_ROLE_EDITOR	= 1;
	
	public static final int DATA_TYPE_EDITOR 		= 2;
	
	public static final int DEFAULT_EDITOR				= 0;


	protected BaseAttribute baseattrib;

	/**
	 * Default Constructor for editing a <code>JTextField</code>.
	 */
	public BaseAttributeEditor() {
		super(new JTextField());
		baseattrib=null;
	}

	/**
	 *Constructs new <code>ParameterEditor</code> with a <code>JTextField</code>.
	 */
	public BaseAttributeEditor(BaseAttribute baseattrib, int editor) {
		super(new JTextField());
		this.baseattrib=baseattrib;
		switch (editor){
			case NAME_EDITOR:{
				
				editorComponent = new JTextField(baseattrib.getName());
				this.clickCountToStart = 2;
				delegate = new EditorDelegate() {
					public void setValue(Object value) {
						((JTextField) editorComponent).setText((value != null) ? value.toString() : "");
					}

					public Object getCellEditorValue() {
						return ((JTextField) editorComponent).getText();
					}
				};
				((JTextField) editorComponent).addActionListener(delegate);
				break;
			}
			case ATTRIBUTE_ROLE_EDITOR:{
				Object[] roles=new Object[]{
						Roles.ROLE_PREDICTOR, Roles.ROLE_LABEL, Roles.ROLE_KEY, Roles.ROLE_NOROLE};
				editorComponent = new JComboBox(roles);
				try {
					((JComboBox) editorComponent).setSelectedItem(baseattrib.getRoleName());
				}
				catch (M4Exception m4e) {
					// seems we can't do much here
				}
				this.clickCountToStart = 1;
				((JComboBox) editorComponent).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
				delegate = new EditorDelegate() {
					public void setValue(Object value) {
						((JComboBox) editorComponent).setSelectedItem(value);
					}

					public Object getCellEditorValue() {
						return ((JComboBox) editorComponent).getSelectedItem();
					}
                
					public boolean shouldSelectCell(EventObject anEvent) { 
						if (anEvent instanceof MouseEvent) { 
							MouseEvent e = (MouseEvent)anEvent;
							return e.getID() != MouseEvent.MOUSE_DRAGGED;
						}
						return true;
					}
					
					public boolean stopCellEditing() {
						if (((JComboBox) editorComponent).isEditable()) {
							// Commit edited value.
							((JComboBox) editorComponent).actionPerformed(new ActionEvent(BaseAttributeEditor.this, 0, ""));
						}
						return super.stopCellEditing();
					}
				};
				((JComboBox) editorComponent).addActionListener(delegate);
				break;
			}
			case DATA_TYPE_EDITOR:{
				Object[] cdtypes=new Object[ConceptualDatatypes.CDTYPES.length];
				for(int i=0;i<cdtypes.length;i++){
					cdtypes[i]=ConceptualDatatypes.CDTYPES[i];
				}
				editorComponent = new JComboBox(cdtypes);
				try {
					((JComboBox) editorComponent).setSelectedItem(baseattrib.getConceptualDataTypeName());
				} catch (M4Exception error) {
					M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
				}
				this.clickCountToStart = 1;
				((JComboBox) editorComponent).putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
				delegate = new EditorDelegate() {
					public void setValue(Object value) {
						((JComboBox) editorComponent).setSelectedItem(value);
					}

					public Object getCellEditorValue() {
						return ((JComboBox) editorComponent).getSelectedItem();
					}
                
					public boolean shouldSelectCell(EventObject anEvent) { 
						if (anEvent instanceof MouseEvent) { 
							MouseEvent e = (MouseEvent)anEvent;
							return e.getID() != MouseEvent.MOUSE_DRAGGED;
						}
						return true;
					}
					
					public boolean stopCellEditing() {
						if (((JComboBox) editorComponent).isEditable()) {
							// Commit edited value.
							((JComboBox) editorComponent).actionPerformed(new ActionEvent(BaseAttributeEditor.this, 0, ""));
						}
						return super.stopCellEditing();
					}
				};
				((JComboBox) editorComponent).addActionListener(delegate);
				break;
			}
			default:{
				editorComponent = new JTextField();
				this.clickCountToStart = 2;
				delegate = new EditorDelegate() {
					public void setValue(Object value) {
						((JTextField) editorComponent).setText((value != null) ? value.toString() : "");
					}

					public Object getCellEditorValue() {
						return ((JTextField) editorComponent).getText();
					}
				};
				((JTextField) editorComponent).addActionListener(delegate);
				break;
			}	
		}
	}

	/**
	 *Gets the <code>editorComponent</code>.
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(JTable, Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		editorComponent.setBackground((Color) UIManager.get("Table.background"));
		return editorComponent;
	}

}
/*
 * Historie
 * --------
 *
 * $Log: BaseAttributeEditor.java,v $
 * Revision 1.5  2006/09/27 15:00:02  euler
 * New version 1.1
 *
 * Revision 1.4  2006/08/04 14:49:29  euler
 * *** empty log message ***
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:25  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.3  2005/11/03 10:46:25  hakenjos
*** empty log message ***

Revision 1.2  2005/10/18 09:31:54  hakenjos
*** empty log message ***

Revision 1.1  2005/10/11 07:57:57  hakenjos
*** empty log message ***

 */
