/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.event.MouseEvent;

import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.standard.ConnectionTool;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.util.LogFile;

import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A ConnectionTool for transitions.
 * @author Daniel Hakenjos
 * @version $Id: StepTransitionTool.java,v 1.4 2006/09/27 15:00:02 euler Exp $
 */
public class StepTransitionTool extends ConnectionTool{

	private MiningMartApplication parent;
	private Class startType;

	private String startName;

	private Class endType;

	private String endName;

	private Class modelClass;

    private ModelConnectionElement newElement;
    
	public StepTransitionTool(MiningMartApplication parent, Class modelClass, Class startType, String startName, Class endType, String endName) {
		super(parent,null);
		this.parent = parent;

		this.startType = startType;
		this.startName = startName;
		this.endType = endType;
		this.endName = endName;
		this.modelClass = modelClass;
	}

	/**
	 * @see CH.ifa.draw.standard.ConnectionTool#createConnection()
	 */
	protected ConnectionFigure createConnection() {
		LineConnection line = new LineConnection();

		line.setStartDecoration(null);
		line.setEndDecoration(null);
		line.setAttribute("label", null);

		return line;
	}

	/**
	 * Creates new ModelConnectionElement.
	 */
	 protected ModelConnectionElement createElement(Model model, ModelElement start, ModelElement end, boolean existsTransition){
			StepTransition trans;

			if (model instanceof MiningMartChain){
				trans=((MiningMartChain) model).createTransition(null, (ModelFigureElement) start, (ModelFigureElement) end, existsTransition);

				if (trans==null){
					editor().toolDone(); 
					return null;
				}
				trans.setMMartApplication(((MiningMartChain) model).getMMartApplication());
				editor().toolDone();					
				return trans;
			}

			trans=((MiningMartCase) model).createTransition(null, (ModelFigureElement) start, (ModelFigureElement) end, existsTransition);
			if (trans==null){
				editor().toolDone(); 
				return null;
			}
			
			trans.setMMartApplication(((MiningMartCase) model).getMMartApplication());
			editor().toolDone();
			return trans;
	 }

	/**
	 * MouseUp<br>
	 * <br>
	 * - create ModelElement<br>
	 * - and get the figure<br>
	 * 
	 * @see CH.ifa.draw.framework.Tool#mouseUp(java.awt.event.MouseEvent, int, int)
	 */
	public void mouseUp(MouseEvent e, int x, int y) {
		ConnectionFigure fig = (ConnectionFigure) getAddedFigure();
		
		super.mouseUp(e,x,y);

        newElement = null;

		if (fig != null) {
			ModelFigure startFigure = (ModelFigure) fig.startFigure();
			ModelFigure endFigure = (ModelFigure) fig.endFigure();

			if (startFigure != null && endFigure != null) {
				ModelFigureElement startElement = startFigure.getElement();
				ModelFigureElement endElement = endFigure.getElement();

				boolean existstrans=false;
				Model parentmodel=(Model) startElement.getParent();
				StepTransition exists;				
				for(int c=0;((c<parentmodel.getConnectionCount())&&(!existstrans));c++){
					exists=(StepTransition) parentmodel.getConnection(c);
					if ((exists.getStart().getName().equals(startElement.getName()))&&
						(exists.getEnd().getName().equals(endElement.getName()))){
					
						existstrans=true;
					}
				}
				
				drawing().remove(fig);
				fig.release();
//				System.out.println("existsttrans: "+existstrans);
				// Syntaxcheck auf temporaerer Instanz
				try {
					ModelConnectionElement temp = (ModelConnectionElement) modelClass.newInstance();
					
					if (temp.canConnect(startElement, endElement)) {
						newElement = createElement(((ModelDrawing) drawing()).getModel(), startElement, endElement, existstrans);
					}
					else {
						parent.showStatus(Resource.getString("TXT_ILLEGAL_CONNECTION") + ": " + startElement.getName() + " --> " + endElement.getName());
						parent.getToolkit().beep();
					}
				}
				catch (Exception ignored) {
					LogFile.log(ignored); // :-)
				}
					
			}
		}

		if (newElement!=null){
			parent.selectFigure((ModelConnectionElement) getElement());
			M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("CREATED_NEW_TRANSITION")+" "+((ModelConnectionElement) getElement()).getName());
		}
	}
    
    /**
     * Gets the ModelConnectionElement.
     */
    public ModelConnectionElement getElement() {
        return newElement;
    }
    
    /**
     * @see org.musoft.limo.application.Application#followPointer(int,int)
     */
	public void mouseDrag(MouseEvent e, int x, int y) {
		super.mouseDrag(e, x, y);
		parent.followPointer(x, y);
	}

}

/*
 $Log: StepTransitionTool.java,v $
 Revision 1.4  2006/09/27 15:00:02  euler
 New version 1.1

 Revision 1.3  2006/04/11 14:10:16  euler
 Updated license text.

 Revision 1.2  2006/04/06 16:31:15  euler
 Prepended license remark.

 Revision 1.1  2006/01/03 09:54:27  hakenjos
 Initial version!

 */
