/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;

import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;


/**
 * A StartWindow for the <code>MiningMartApplication</code>.
 * @author Daniel Hakenjos
 * @version $Id: StartWindow.java,v 1.4 2006/09/27 15:00:01 euler Exp $
 */
public class StartWindow extends JWindow{

	private ImageIcon logo;

    private String message = "Starting up.";

    private String productName;
    
    private String version;
    
    private WindowLabel startupLabel;

    /**
     * Init the StartWindow.
     */
    public StartWindow(){
        this(Resource.getString("APP_TITLE"),
                Resource.getString("APP_VERSION"));
    }
    

    /**
     * Init the StartWindow with the productname, version and a logo.
     * @param productName
     * @param version
     * @param logo
     */
    public StartWindow(String productName, String version) {
    	this.productName=productName;
    	this.version=version;
        this.logo = new ImageIcon((new Iconkit(this)).loadImageResource(Resource.getString("MMART_IMAGE")));

		//
		// Show startup screen
		//
		
		JPanel top=new JPanel(new BorderLayout());
		top.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		getContentPane().add( top, java.awt.BorderLayout.CENTER);
		
		
		startupLabel = new WindowLabel(logo);
		top.add(startupLabel,BorderLayout.CENTER);
		
		pack();
		Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();

		Dimension startupWindowSize = getSize();

		setLocation(
			(screenSize.width - startupWindowSize.width) / 2,
			(screenSize.height - startupWindowSize.height) / 2);
		setVisible(true);


//        getContentPane().add(panel);

    }

    /**
     * Sets this message to the window.
     * @param message
     */
    public void setMessage(String message) {
        this.message = message;
        repaint();
    }
    
    private class WindowLabel extends JLabel{
    	
    	public WindowLabel(Icon icon){
    		super(icon);
    	}
        
        public void paint(Graphics g){
        	super.paint(g);
        	g.setColor(Color.DARK_GRAY);

			String title=productName+ " "+version;
        	
        	Dimension size=this.getSize();

			Font font=new Font("LucidaSans", java.awt.Font.PLAIN, 12);
			FontMetrics fm=getFontMetrics(font);
			int titlewidth=fm.stringWidth(title);
        	
            g.setFont(font);
            g.drawString(title,size.width-titlewidth-20,size.height-40);
            
			font=new Font("LucidaSans", java.awt.Font.PLAIN, 10);
            g.setFont(font);
            fm=getFontMetrics(font);
            int messagewidth=fm.stringWidth(message);
            g.drawString(message, size.width-messagewidth-20, size.height-20);
        }
    }

}
/*
$Log: StartWindow.java,v $
Revision 1.4  2006/09/27 15:00:01  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:27  hakenjos
Initial version!

*/
