/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import org.musoft.limo.application.Resource;

/**
 * A <code>JDialog</code> to edit the preferences.
 * @author Daniel Hakenjos
 * @version $Id: PreferencesFrame.java,v 1.4 2006/09/27 15:00:01 euler Exp $
 */
public class PreferencesFrame extends JDialog{
	
	private class ButtonActions implements ActionListener{

		public void actionPerformed(ActionEvent event){
    		String cmd = event.getActionCommand();
			PreferencesPanel pp;
			for (int index=0;index<preferencespanels.size();index++){
				pp=(PreferencesPanel) preferencespanels.get(index);

  		        if (cmd.equals(Resource.getString("SAVE"))) {
			    	pp.actionSave();
			    }
			    else if (cmd.equals(Resource.getString("OK"))) {
					pp.actionOK();
					
		    	}
		     	else if (cmd.equals(Resource.getString("CANCEL"))) {
					pp.actionCancel();
		     	}
		     	else{
					//nothing
		     	}
			}

		    if (cmd.equals(Resource.getString("OK"))) {
				setVisible(false);
				dispose();				
	    	}
	     	else if (cmd.equals(Resource.getString("CANCEL"))) {
				setVisible(false);
				dispose();				
	     	}
	     	else{
				//nothing
	     	}

		}	
	}

	private JTabbedPane tabbedpane;
	private JButton save,ok,cancel;	
	private Vector preferencespanels;

	/**
	 * Constructor for PreferencesFrame.
	 */
	public PreferencesFrame(JFrame owner,String title) {
		super(owner,title);
		this.preferencespanels=new Vector();
		initComponents();
		this.setDefaultCloseOperation(JDialog.EXIT_ON_CLOSE);		
	}
	
	private void initComponents(){
		Container content = this.getContentPane();
		BorderLayout bl=new BorderLayout();
		bl.setHgap(5);
		bl.setVgap(5);

		tabbedpane=new JTabbedPane();

		JPanel borderpanel=new JPanel();
		borderpanel.setLayout(new BorderLayout());
		
		borderpanel.add(tabbedpane,BorderLayout.CENTER);
		
		JPanel actions=new JPanel();
		actions.setLayout(bl);

		GridLayout gl=new GridLayout(1,3);
		gl.setHgap(5);
		gl.setVgap(5);	

		JPanel buttons=new JPanel();
		buttons.setLayout(gl);
		
		save=new JButton(Resource.getString("SAVE"));
		ok=new JButton(Resource.getString("OK"));
		cancel=new JButton(Resource.getString("CANCEL"));
		
		ButtonActions bactions=new ButtonActions();
		
		save.addActionListener(bactions);
		ok.addActionListener(bactions);
		cancel.addActionListener(bactions);
		
		buttons.add(save);
		buttons.add(ok);
		buttons.add(cancel);
		actions.add(buttons,BorderLayout.EAST);
		
		borderpanel.add(actions,BorderLayout.SOUTH);
		
		content.add(borderpanel);	
	}
	
	/**
	 * Adds a <code>PreferencesPanel</code> to the <code>JTabbedPane</code> with the specified name for the tab.
	 */
	public void addPreferencePanel(String tabname,PreferencesPanel pref_panel){
		tabbedpane.add(tabname,pref_panel);
		this.preferencespanels.add(pref_panel);		
	}

}
/*
$Log: PreferencesFrame.java,v $
Revision 1.4  2006/09/27 15:00:01  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
