/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.musoft.limo.application.Resource;

/**
 * A dialog to enter a name for a new case.
 * @author Daniel Hakenjos
 * @version $Id: NewCaseDialog.java,v 1.4 2006/09/27 15:00:02 euler Exp $
 */
public class NewCaseDialog extends JDialog implements ActionListener{

	public final int CANCEL=0;
	public final int OK=1;

	private MiningMartApplication app;

	private JTextField field;
	private JButton cancel, ok;
	private int exitAction;

	/**
	 * Constructor for NewCaseDialog.
	 */
	public NewCaseDialog(MiningMartApplication parent) {
		super(parent, Resource.getString("DIALOG_NEW_CASE_TITLE"), true);
		
		this.app=parent;
		this.exitAction=CANCEL;	
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		
		this.pack();

		setSize(250,100);

		Dimension size=this.getSize();

		this.setLocation(
        (Toolkit.getDefaultToolkit().getScreenSize().width-
         size.width) / 2,
        (Toolkit.getDefaultToolkit().getScreenSize().height-
         size.height) / 2);
		this.setVisible(true);
	}
	
	/**
	 * Inits the components.
	 */
	public void initComponents(){
		
		JPanel top_panel=new JPanel();
		top_panel.setLayout(new BorderLayout(5,5));
		
		
		cancel=new JButton(Resource.getString("CANCEL"));
		ok=new JButton(Resource.getString("OK"));
		ok.setEnabled(true);
		
		cancel.addActionListener(this);
		ok.addActionListener(this);
		
		field=new JTextField();
		
		JLabel label=new JLabel(Resource.getString("CASE")+":");
		
		JPanel mid_panel=new JPanel();
		mid_panel.setLayout(new BorderLayout(5,0));
		mid_panel.add(label,BorderLayout.WEST);
		
		mid_panel.add(field, BorderLayout.CENTER);

		top_panel.add(mid_panel,BorderLayout.CENTER);
		
		JPanel bottom=new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(ok);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);
		
		top_panel.add(bottom,BorderLayout.SOUTH);
		
		top_panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		this.getContentPane().add(top_panel);
	}
	
	
	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e){
		String cmd=e.getActionCommand();
		if (cmd.equals(Resource.getString("CANCEL"))){
			exitAction=CANCEL;
			this.dispose();
		}
		if (cmd.equals(Resource.getString("OK"))){
			exitAction=OK;
			this.dispose();
		}
	}
	
	/**
	 * Gets the exit-action.
	 */
	public int getExitAction(){
		return exitAction;
	}
	
	/**
	 * Gets the name of the new case.
	 */
	public String getNewCaseName(){
		if (exitAction==OK)
			return field.getText();
		return null;
	}
	
}
/*
$Log: NewCaseDialog.java,v $
Revision 1.4  2006/09/27 15:00:02  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
