/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.Dimension;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.IconCommandMenu;
import org.musoft.limo.application.MenuBar;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelFigureElement;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.gui.util.RecentFiles;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A <code>MenuBar</code> for the <code>MiningMartApplication</code>.
 * 
 * @author Daniel Hakenjos
 * @version $Id: MiningMartMenuBar.java,v 1.16 2006/10/06 14:11:30 euler Exp $
 */
public class MiningMartMenuBar extends MenuBar {

	private MiningMartApplication app;

	private RecentFiles recentfiles;

	private CommandMenu recentFiles;

	private static JCheckBoxMenuItem compileMode;
	
	private IconCommandMenu operatorsmenu;

	private JMenu switchmode;
	
	public JCheckBoxMenuItem show_tools,show_annotations,show_help;

	JRadioButtonMenuItem caseeditor,concepteditor;
	
	/**
	 * Constructor for MiningMartMenuBar.
	 * @param p the <code>Application</code>.
	 */
	public MiningMartMenuBar(Application p) {
		super(p);
		app = (MiningMartApplication) p;
		//		setRecentCases();
		initItemStates();
	}

	/**
	 * Creates the menus.
	 */
	protected void createMenus() {
		setRecentCases();
		addMenu(this.createCaseMenu());
		//addMenu(this.createEditMenu());
		addMenu(this.createInsertMenu());
		addMenu(this.createCompileMenu());
		addMenu(this.createToolsMenu());
		addMenu(this.createWindowMenu());
		addMenu(this.createHelpMenu());
	}

	/**
	 * Gets the recent cases.
	 */
	public RecentFiles getRecentCases() {
		return this.recentfiles;
	}

	/**
	 * Sets the recent cases from the preferences.
	 * @see org.musoft.limo.application.Application#loadParams()
	 */
	public void setRecentCases() {
		recentfiles = new RecentFiles(8);

		parent.loadParams();

		String recent =
			((MiningMartApplication) this.parent).getPreferences().getString(
				"RecentCases");
		if (recent == null) {
			recent = new String("");
		}
		StringTokenizer st = new StringTokenizer(recent, ";");

		String token;
		int pos = 1;
		while (st.hasMoreTokens()) {
			token = st.nextToken();
			recentfiles.setRecentFile(token, pos);
			pos++;
		}

		setRecentCasesGUI();

	}
	
	/**
	 * Removes cases which are not existing.
	 */
	public void removeRecentCases(){
		//the m4interface must be instantiated.
		M4Interface m4interface=MiningMartApplication.m4Interface;
		if (m4interface==null)
			return;

		String recfile;
		for (int i = recentfiles.getSize()-1; i >=0; i--) {
			recfile = recentfiles.getFile(i);
			if (!m4interface.existsCase(recfile)){
				recentfiles.removeRecentFile(recfile);
			}
		}
	}

	/**
	 * Sets the GUI of the recent cases.
	 */
	public void setRecentCasesGUI() {
		Iconkit kit = Iconkit.instance();
		
		removeRecentCases();

		if (recentFiles==null){
			recentFiles = new CommandMenu(Resource.getString("MENU_CASE_RECENT"));
			recentFiles.setMnemonic(Resource.getChar("MENUM_CASE_RECENT"));
			recentFiles.setIcon(
				new ImageIcon(
					kit.loadImageResource(
						Resource.getString("MENU_ICON_CASE_RECENT"))));
		}else{
			recentFiles.removeAll();
		}
		String recfile;
		Command cmd;
		for (int i = 0; i < recentfiles.getSize(); i++) {
			recfile = recentfiles.getFile(i);
			cmd = new AbstractCommand(recfile, parent, false) {
				public void execute() {
					((MiningMartApplication) parent).promptOpen(
						this.name(),
						true,
						false);
				}
			};
			recentFiles.add(cmd);

		}

	}

	/**
	 * Inits the states of the menu-items.
	 */
	public void initItemStates() {

		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_MODE"),
			false);
		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_EXPORT"),
			false);
		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_SAVE"),
			false);
		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_CLOSE"),
			false);

		this.setItemState(
			Resource.getString("MENU_EDIT")
				+ "."
				+ Resource.getString("MENU_EDIT_CUT"),
			false);
		this.setItemState(
			Resource.getString("MENU_EDIT")
				+ "."
				+ Resource.getString("MENU_EDIT_COPY"),
			false);
		this.setItemState(
			Resource.getString("MENU_EDIT")
				+ "."
				+ Resource.getString("MENU_EDIT_PASTE"),
			false);
		this.setItemState(
			Resource.getString("MENU_EDIT")
				+ "."
				+ Resource.getString("MENU_EDIT_DELETE"),
			false);

		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_VALIDATE"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_VALIDATE_ALL"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_ALL"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_FROM_SELECTED"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_STEP"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_LAZY"),
			false);
		this.setItemState(
				Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_TOOLS_GARBAGE"),
			false);
		this.setItemState(
			Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_COMPILE_KILL"),
			false);

		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_CONCEPT"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_RELATION"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_SUBCONCEPT"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_SUBRELATION"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_CONCEPTFROMCASE"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_CHAIN"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_MERGE_CHAIN"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_UNMERGE_CHAIN"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_TRANSITION"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_ALL_TRANSITIONS"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"),
			false);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_OPERATORS"),
			false);
		this.setItemState(
			Resource.getString("MENU_TOOLS")
				+ "."
				+ Resource.getString("MENU_TOOLS_GARBAGE"),
			false);
		this.setItemState(
				Resource.getString("MENU_TOOLS")
					+ "."
					+ Resource.getString("MENU_TOOLS_ADDREVSTEP"),
				false);
		this.setItemState(
				Resource.getString("MENU_TOOLS")
					+ "."
					+ Resource.getString("MENU_TOOLS_MAT_RECOMMEND"),
				false);
		this.setItemState(
				Resource.getString("MENU_TOOLS")
					+ "."
					+ Resource.getString("MENU_TOOLS_GRID_ARRANGE"),
				false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MATCH_INITIAL"),
					false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MATCH_ANY"),
					false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MATCH_STEPRESULT"),
					false);
			
		compileMode.setEnabled(false);

		show_annotations.setEnabled(false);
		show_tools.setEnabled(false);
		
		switchmode.setEnabled(false);

	}


	/**
	 * Sets the state of the compile menu-items when the compilation starts.
	 */
	public void promptStartCompilationItemStates(){

			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_ALL"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_FROM_SELECTED"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_STEP"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_LAZY"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_KILL"),
				true);
	}

	/**
	 * Sets the state of the compile menu-items when the compilation is done.
	 */
	public void promptDoneCompilationItemStates(){
		
		this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_ALL"),
				true);
		// if in case editor mode, activate the other menu items too:
		if (((MiningMartApplication) parent).getEditorMode()==MiningMartApplication.CASE_MODE){
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_FROM_SELECTED"),
				true);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
				true);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_STEP"),
				true);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_LAZY"),
				true);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_KILL"),
				false);
		}
	}


	/**
	 * Sets the state of the menu-items after a case was opened.
	 */
	public void promptOpenItemStates() {
		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_CLOSE"),
			true);
		this.setItemState(
			Resource.getString("MENU_CASE")
				+ "."
				+ Resource.getString("MENU_CASE_EXPORT"),
			true);
		
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_ALL_TRANSITIONS"),
			true);
		this.setItemState(
			Resource.getString("MENU_INSERT")
				+ "."
				+ Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"),
			true);
		this.setItemState(
				Resource.getString("MENU_COMPILE")
				+ "."
				+ Resource.getString("MENU_TOOLS_GARBAGE"),
			true);
		show_annotations.setEnabled(true);
		switchmode.setEnabled(true);

		if (app.getViewMode() == Application.EDITOR) {
			show_tools.setEnabled(true);

			this.setItemState(
				Resource.getString("MENU_CASE")
					+ "."
					+ Resource.getString("MENU_CASE_MODE"),
				true);
			this.setItemState(
				Resource.getString("MENU_EDIT")
					+ "."
					+ Resource.getString("MENU_EDIT_CUT"),
				true);
			this.setItemState(
				Resource.getString("MENU_EDIT")
					+ "."
					+ Resource.getString("MENU_EDIT_COPY"),
				true);
			this.setItemState(
				Resource.getString("MENU_EDIT")
					+ "."
					+ Resource.getString("MENU_EDIT_PASTE"),
				true);
			this.setItemState(
				Resource.getString("MENU_EDIT")
					+ "."
					+ Resource.getString("MENU_EDIT_DELETE"),
				true);

			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPT"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_RELATION"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SUBCONCEPT"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SUBRELATION"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPTFROMCASE"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"),
				true);
			this.setItemState(
				Resource.getString("MENU_TOOLS")
					+ "."
					+ Resource.getString("MENU_TOOLS_GARBAGE"),
				true);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_ADDREVSTEP"),
					true);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MAT_RECOMMEND"),
					true);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_GRID_ARRANGE"),
					true);
			/*
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_INITIAL"),
						false);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_ANY"),
						false);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_STEPRESULT"),
						false);
						*/
			compileMode.setEnabled(true);
			
		}
		
		promptSwitchEditor();

	}

	/**
	 * Sets the state of the menu-items for a new case.
	 */
	public void promptNewItemStates() {
		promptOpenItemStates();
	}

	/**
	 * Sets the state of the menu-items when closing a case.
	 */
	public void promptCloseItemStates() {
		initItemStates();
	}
	
	/**
	 * Switches the mode of the editor in the menu.
	 * This means several items are enabled or not.
	 */
	public void promptSwitchEditor(){
		if (app.getEditorMode()==MiningMartApplication.CASE_MODE){
			this.caseeditor.setSelected(true);
			this.concepteditor.setSelected(false);

			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_ALL_TRANSITIONS"),
				true);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"),
				true);

			//disable Tools der Konzepte
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPT"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_RELATION"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SUBCONCEPT"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SUBRELATION"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPTFROMCASE"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"),
				false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_ADDREVSTEP"),
					true);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MAT_RECOMMEND"),
					true);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_GRID_ARRANGE"),
					true);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_INITIAL"),
						false);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_ANY"),
						false);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_STEPRESULT"),
						false);

			if (app.getViewMode() == Application.EDITOR) {

				this.setItemState(
					Resource.getString("MENU_INSERT")
						+ "."
						+ Resource.getString("MENU_INSERT_CHAIN"),
					true);
				this.setItemState(
					Resource.getString("MENU_INSERT")
						+ "."
						+ Resource.getString("MENU_INSERT_MERGE_CHAIN"),
					true);
				this.setItemState(
					Resource.getString("MENU_INSERT")
						+ "."
						+ Resource.getString("MENU_INSERT_UNMERGE_CHAIN"),
					true);
				this.setItemState(
					Resource.getString("MENU_INSERT")
						+ "."
						+ Resource.getString("MENU_INSERT_TRANSITION"),
					true);
				this.setItemState(
					Resource.getString("MENU_INSERT")
						+ "."
						+ Resource.getString("MENU_OPERATORS"),
					true);
	
	
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_VALIDATE"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_VALIDATE_ALL"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_ALL"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_FROM_SELECTED"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_STEP"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_LAZY"),
					true);
				this.setItemState(
					Resource.getString("MENU_COMPILE")
						+ "."
						+ Resource.getString("MENU_COMPILE_KILL"),
					false);
			}//EDITOR_MODE


		}else{
			this.caseeditor.setSelected(false);
			this.concepteditor.setSelected(true);

			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_ALL_TRANSITIONS"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"),
				false);

			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_CHAIN"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_MERGE_CHAIN"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_UNMERGE_CHAIN"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_INSERT_TRANSITION"),
				false);
			this.setItemState(
				Resource.getString("MENU_INSERT")
					+ "."
					+ Resource.getString("MENU_OPERATORS"),
				false);
	
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_VALIDATE"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_VALIDATE_ALL"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_ALL"),
				true); // only compile all makes sense in concept editor
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_FROM_SELECTED"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_STEP"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_LAZY"),
				false);
			this.setItemState(
				Resource.getString("MENU_COMPILE")
					+ "."
					+ Resource.getString("MENU_COMPILE_KILL"),
				false);


			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_ADDREVSTEP"),
					false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_MAT_RECOMMEND"),
					false);
			this.setItemState(
					Resource.getString("MENU_TOOLS")
						+ "."
						+ Resource.getString("MENU_TOOLS_GRID_ARRANGE"),
					true);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_INITIAL"),
						true);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_ANY"),
						true);
				this.setItemState(
						Resource.getString("MENU_TOOLS")
							+ "."
							+ Resource.getString("MENU_TOOLS_MATCH_STEPRESULT"),
						true);
			
			if (app.getViewMode() == Application.EDITOR) {
				//enable Tools der Konzepte 
			}//EDITOR_MODE

		}
		
	}

	/**
	 * Creates the menu for the case.
	 */
	protected JMenu createCaseMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_CASE"));

		menu.setMnemonic(Resource.getChar("MENUM_CASE"));

		Command cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_NEW"),
				parent,
				false) {
			public void execute() {
				parent.promptNew();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_NEW")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_NEW"))));
		
		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_NEW_FROMDATA"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).promptNewCaseFromData();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_NEW_FROMDATA")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_NEW"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_OPEN"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).promptOpen(null, true, false);
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_OPEN")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_OPEN"))));

		menu.add(this.recentFiles);

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_MODE"),
				parent,
				true) {
			public void execute() {
				app.promptSetMode();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_MODE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_MODE"))));


		switchmode =new JMenu(Resource.getString("MENU_CASE_SWITCH_EDITOR"));
		menu.add(switchmode);

		ButtonGroup group = new ButtonGroup();
		
		caseeditor=new JRadioButtonMenuItem(Resource.getString("COMP_CASEEDITOR"));
		caseeditor.setMnemonic(Resource.getChar("MENUM_CASE_SWITCH_CASEEDITOR"));
		concepteditor=new JRadioButtonMenuItem(Resource.getString("COMP_CONCEPTEDITOR"));
		concepteditor.setMnemonic(Resource.getChar("MENUM_CASE_SWITCH_CONCEPTEDITOR"));
		
		caseeditor.addActionListener(new RadioButtonListener(caseeditor){
			public void actionPerformed(ActionEvent event){
				app.saveModel();
				String casename=app.getModel().getName();
				if (app.getEditorMode()==MiningMartApplication.CONCEPT_MODE){
					casename=M4Interface.getCurrentCase().getName();
				}
				boolean editing=app.getViewMode()==Application.EDITOR;
				MiningMartApplication.keepCase = true;
				app.promptClose();
				app.setEditorMode(MiningMartApplication.CASE_MODE);
				app.promptOpen(casename,editing, false);
				MiningMartApplication.keepCase = false;
			}
		});

		concepteditor.addActionListener(new RadioButtonListener(concepteditor){
			public void actionPerformed(ActionEvent event){
				app.saveModel();
				String casename=app.getModel().getName();
				boolean editing=app.getViewMode()==Application.EDITOR;
				if (app.getEditorMode()==MiningMartApplication.CONCEPT_MODE){
					casename=M4Interface.getCurrentCase().getName();
				}
				MiningMartApplication.keepCase = true;
				app.promptClose();
				app.setEditorMode(MiningMartApplication.CONCEPT_MODE);
				app.promptOpen(casename,editing, false);
				MiningMartApplication.keepCase = false;
			}
		});
		group.add(caseeditor);
		group.add(concepteditor);
		
		caseeditor.setSelected(true);	
		switchmode.add(caseeditor);
		switchmode.add(concepteditor);


		menu.addSeparator();

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_SAVE"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).saveModel();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_SAVE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_SAVE"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_IMPORT"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).importCase();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_IMPORT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_IMPORT"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_EXPORT"),
				parent,
				true) {
			public void execute() {
				((MiningMartApplication) parent).exportCase();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_EXPORT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_EXPORT"))));


		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_PRINT"),
				parent,
				true) {
			public void execute() {
				parent.promptPrint(true);
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_PRINT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_PRINT"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_EXPORT_IMAGE"),
				parent,
				true) {
			public void execute() {
				parent.promptExport();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_EXPORT_IMAGE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_EXPORT_IMAGE"))));

		menu.addSeparator();

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_DELETE"),
				parent,
				true) {
			public void execute() {
				((MiningMartApplication) parent).promptDeleteCase();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_DELETE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_DELETE"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_CLOSE"),
				parent,
				true) {
			public void execute() {
				parent.promptClose();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_CLOSE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_CLOSE"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_CASE_EXIT"),
				parent,
				true) {
			public void execute() {
				parent.exit();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_CASE_EXIT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_CASE_EXIT"))));

		return menu;
	}

	/**
	 * Creates the edit-menu.
	 */
	public JMenu createEditMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_EDIT"));

		menu.setMnemonic(Resource.getChar("MENUM_EDIT"));

		Command cmd =
			new AbstractCommand(
				Resource.getString("MENU_EDIT_CUT"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showHelp();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_EDIT_CUT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_EDIT_CUT"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_EDIT_COPY"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showHelp();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_EDIT_COPY")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_EDIT_COPY"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_EDIT_PASTE"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showHelp();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_EDIT_PASTE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_EDIT_PASTE"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_EDIT_DELETE"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showHelp();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_EDIT_DELETE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_EDIT_DELETE"))));

		return menu;
	}

	/**
	 * Creates the window-menu.
	 */
	public JMenu createWindowMenu() {
		Iconkit kit = Iconkit.instance();
		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_WINDOW"));

		IconCommandMenu submenu1 =
			new IconCommandMenu(Resource.getString("MENU_WINDOW_GRID"));
		menu.add(submenu1);

		AbstractCommand gridCmd1 =
			new AbstractCommand(
				Resource.getString("MENU_WINDOW_GRID_ON"),
				parent) {
			public void execute() {
				// boolean value = !parent.getMainPane().getGrid();
				parent.getMainPane().setGrid(true);
			}
		};
		submenu1.add(
			gridCmd1,
			new MenuShortcut(Resource.getChar("MENUM_WINDOW_GRID_ON")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_WINDOW_GRID_ON"))));

		AbstractCommand gridCmd2 =
			new AbstractCommand(
				Resource.getString("MENU_WINDOW_GRID_OFF"),
				parent) {
			public void execute() {
				// boolean value = !parent.getMainPane().getGrid();
				parent.getMainPane().setGrid(false);
			}
		};
		submenu1.add(
			gridCmd2,
			new MenuShortcut(Resource.getChar("MENUM_WINDOW_GRID_OFF")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_WINDOW_GRID_OFF"))));

		IconCommandMenu submenu =
			new IconCommandMenu(Resource.getString("Look'n'Feel"));
		menu.add(submenu);

		UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();

		for (int i = 0; i < lafs.length; i++) {
			final String lnfClassName = lafs[i].getClassName();
			Command cmd =
				new AbstractCommand(lafs[i].getName(), parent, false) {
				public void execute() {
					try {
						UIManager.setLookAndFeel(lnfClassName);
						MiningMartApplication.setTabbedPaneUiGlobally();
						SwingUtilities.updateComponentTreeUI(parent);
					} catch (Exception e) {
						M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
//						JOptionPane.showMessageDialog(app,e.getMessage(),"Set look and feel...",JOptionPane.ERROR_MESSAGE);
					}
				}
			};
			submenu.add(cmd);
		}
		
		JMenu showmenu =
			new JMenu(Resource.getString("MENU_WINDOW_SHOW"));
		menu.add(showmenu);
		
		
		show_annotations=new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_ANNOTATIONS"));
		show_annotations.addActionListener(new CheckBoxListener(show_annotations){
			public void actionPerformed(ActionEvent event){
				if (box.isSelected())
				 	app.showAnnotations();
				else
				 	((MiningMartApplication) app).removeAnnotations();
			}	
		}
		);
		show_annotations.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_ANNOTATIONS"));
		showmenu.add(show_annotations);
	
		show_help=new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_HELP"));
		show_help.addActionListener(new CheckBoxListener(show_help){
			public void actionPerformed(ActionEvent event){
				if (box.isSelected())
				 	app.showHelp();
				else
				 	app.removeHelp();
			}	
		}
		);
		show_help.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_HELP"));
		showmenu.add(show_help);

		show_tools=new JCheckBoxMenuItem(Resource.getString("MENU_WINDOW_SHOW_TOOLS"));
		show_tools.addActionListener(new CheckBoxListener(show_tools){
			public void actionPerformed(ActionEvent event){
				if (app.getEditorMode()==MiningMartApplication.CASE_MODE){
					if (box.isSelected())
						app.showOperatorTools();
					else
						app.removeOperatorTools();
				}else{
					if (box.isSelected())
						app.showConceptTools();
					else
						app.removeConceptTools();
				}
			}	
		}
		);
		show_tools.setMnemonic(Resource.getChar("MENUM_WINDOW_SHOW_TOOLS"));
		showmenu.add(show_tools);


		JMenuItem cmd =
			new JMenuItem(Resource.getString("MENU_WINDOW_PRESENTATION"));
		cmd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				parent.setViewMode(Application.FULLSCREEN);
				//if () setThisViewItem(e.getSource()); else ((JMenuItem)e.getSource()).setSelected(false);
			}
		});
		cmd.setMnemonic(Resource.getChar("MENUM_WINDOW_PRESENTATION"));
		cmd.setIcon(
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_PRESENTATION"))));
		menu.add(cmd);

		menu.addSeparator();
		cmd = new JMenuItem(Resource.getString("MENU_WINDOW_PREFERENCES"));
		cmd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {

				PreferencesFrame prefframe =
					new PreferencesFrame(
						app,
						Resource.getString("WINDOW_PREFERENCES"));
				OperatorPreferencesPanel prefpanel =
					new OperatorPreferencesPanel(app);
				VerbosityPreferencesPanel prefpanel2=new VerbosityPreferencesPanel();
				ConceptEditorPreferencesPanel prefpanel3=new ConceptEditorPreferencesPanel(app);

				prefframe.addPreferencePanel(Resource.getString("COMP_OPERATORTOOLS"), prefpanel);
				prefframe.addPreferencePanel(Resource.getString("PREFERENCES_VERBOSITY"), prefpanel2);
				prefframe.addPreferencePanel(Resource.getString("PREFERENCES_CONCEPTEDITOR"),prefpanel3);
				prefframe.setSize(600, 500);


				Dimension screenSize =	java.awt.Toolkit.getDefaultToolkit().getScreenSize();
				Dimension WindowSize = prefframe.getSize();
				prefframe.setLocation(	(screenSize.width - WindowSize.width) / 2,
					(screenSize.height - WindowSize.height) / 2);

				prefframe.setVisible(true);
			}
		});
		cmd.setMnemonic(Resource.getChar("MENUM_WINDOW_PREFERENCES"));
		cmd.setIcon(
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_PREFERENCES"))));
		menu.add(cmd);

		return menu;
	}
	/**
	 * Create a help-menu
	 */
	public JMenu createHelpMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_HELP"));

		menu.setMnemonic(Resource.getChar("MENUM_HELP"));

/*		JMenuItem item=new JMenuItem(Resource.getString("MENU_HELP_CONTENTS"));
		item.setMnemonic(Resource.getChar("MENUM_HELP_CONTENTS"));
		item.setIcon(new ImageIcon(kit.loadImageResource(Resource.getString("MENU_ICON_HELP_CONTENTS"))));
		item.addActionListener(((MiningMartApplication) parent).getDisplayHelp());
		menu.add(item);
*/
		Command cmd=new AbstractCommand(
				Resource.getString("MENU_HELP_CONTENTS"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showHelp();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_HELP_CONTENTS")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_HELP_CONTENTS"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_HELP_MMART"),
				parent,
				false) {
			public void execute() {
				// MiningMartseite oeffnen
				parent.openURLInBrowser(Resource.getString("URL_MMART"));
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_HELP_MMART")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_HELP_MMART"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_HELP_ABOUT"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).showAboutDialog();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_HELP_ABOUT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_HELP_ABOUT"))));

		return menu;
	}

	/**
	 * Create Compile Menu
	 * 
	 */
	public JMenu createCompileMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_COMPILE"));

		menu.setMnemonic(Resource.getChar("MENUM_COMPILE"));

		Command cmd;
/*		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_VALIDATE"),
				parent,
				false) {
			public void execute() {
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_VALIDATE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_VALIDATE"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_VALIDATE_ALL"),
				parent,
				false) {
			public void execute() {
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_VALIDATE_ALL")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_VALIDATE_ALL"))));

		menu.addSeparator();
*/
		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_ALL"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).compileAll();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_ALL")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_ALL"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_FROM_SELECTED"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).compileFrom();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_FROM_SELECTED")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_FROM_SELECTED"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_UNTIL_SELECTED"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).compileUntil();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_UNTIL_SELECTED")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_UNTIL_SELECTED"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_STEP"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).compileStep();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_STEP")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_STEP"))));

		menu.addSeparator();

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_GARBAGE"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).collectGarbage();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_TOOLS_GARBAGE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_TOOLS_GARBAGE"))));
		
		menu.addSeparator();
		
		compileMode=new JCheckBoxMenuItem(Resource.getString("MENU_COMPILE_LAZY"));
		compileMode.setSelected(MiningMartApplication.compileLazy);
		compileMode.addActionListener(new CheckBoxListener(compileMode){
			public void actionPerformed(ActionEvent event){
				MiningMartApplication.compileLazy = box.isSelected();
			}	
		}
		);
		compileMode.setMnemonic(Resource.getChar("MENUM_COMPILE_LAZY"));
		menu.add(compileMode);
//		menu.add(this.createVerbosityPanel());

		menu.addSeparator();

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_COMPILE_KILL"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).killCompilation();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_COMPILE_KILL")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_COMPILE_KILL"))));

		return menu;
	}

	/**
	 * 
	 * Create Tools Menu
	 * 
	 */

	public JMenu createToolsMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_TOOLS"));

		menu.setMnemonic(Resource.getChar("MENUM_TOOLS"));

		Command cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_DBSETTINGS"),
				parent,
				false) {
			public void execute() {
				app.promptEditDbSettings();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_TOOLS_DBSETTINGS")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_TOOLS_DBSETTINGS"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_ADDREVSTEP"),
				parent,
				false) {
			public void execute() {
				app.addReversingStep();
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_ADDREVSTEP"))
			    );

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_MAT_RECOMMEND"),
				parent,
				false) {
			public void execute() {
				app.doMaterialisationRecommendations();
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_MAT_RECOMMEND"))
			    );

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_GRID_ARRANGE"),
				parent,
				false) {
			public void execute() {
				app.doGridArrangement();
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_GRID_ARRANGE"))
			    );
		

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_MATCH_INITIAL"),
				parent,
				false) {
			public void execute() {
				app.doMatch(null, true);
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_MATCH_INITIAL"))
			    );
		
		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_MATCH_ANY"),
				parent,
				false) {
			public void execute() {
				app.doMatch(null, false);
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_MATCH_ANY"))
			    );
		
		cmd =
			new AbstractCommand(
				Resource.getString("MENU_TOOLS_MATCH_STEPRESULT"),
				parent,
				false) {
			public void execute() {
				Step theStep = app.selectStepForMatching();
				if (theStep != null)
					app.doMatch(theStep, false);
			}
		};
		menu.add(	cmd,
			        new MenuShortcut(Resource.getChar("MENUM_TOOLS_MATCH_STEPRESULT"))
			    );
		
		return menu;
	}

	/**
	 * Create Insert Menu
	 * 
	 * 
	 */

	public JMenu createInsertMenu() {
		Iconkit kit = Iconkit.instance();

		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_INSERT"));

		menu.setMnemonic(Resource.getChar("MENUM_INSERT"));

		Command cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_CONCEPT"),
				parent,
				false) {
			public void execute() {
				Point point = app.getPointforConcept();
				int x = point.x, y = point.y;
				ModelFigureElement p = app.getPotentialParent(x, y);
				
				MiningMartConcept s = null;
				
				if (p instanceof MiningMartConcepts){

					NewConceptDialog dialog=new NewConceptDialog(app);
					if (dialog.getExitAction()==dialog.CANCEL){
						parent.toolDone();
						return;
					}

					s = ((MiningMartConcepts) p).createMiningMartConcept(p,dialog.getNewConceptName(), new Point(x,y), dialog.getConceptType());
				}
				else{
					//offensichtlich liegt ein Fehler vor
					parent.toolDone();
					return;
				}
				parent.toolDone();
				if (s != null){
					parent.selectFigure(s);
					M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("INSERTED_NEW_CONCEPT")+" "+s.getName());
				}
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_CONCEPT"))));


		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_CONCEPTFROMTABLE"),
				parent,
				false) {
			public void execute() {
				ConceptFromTableDialog dialog=new ConceptFromTableDialog(app, true);
				if (dialog.getExitAction()==dialog.OK){
					String tablename=dialog.getTableName();
					try{
						Concept concept=M4Interface.getCurrentCase().createConceptFromTable(tablename);
						MiningMartConcepts concepts=app.getMiningMartConcepts();
						concepts.createMiningMartConcept(concepts,concept,app.getPointforConcept());
					}catch(M4Exception error){
						M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
					}
				}
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPTFROMTABLE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_CONCEPTFROMTABLE"))));


		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_CONCEPTFROMCASE"),
				parent,
				false) {
			public void execute() {
				ConceptFromCaseDialog dialog=new ConceptFromCaseDialog(app);
				if (dialog.getExitAction()==dialog.OK){
					Case thecase=dialog.getTheCase();
					String conceptname=dialog.getConceptName();
					try{
						Concept concept=thecase.getConcept(conceptname);
						Concept newconcept=concept.copy(M4Interface.getCurrentCase());
						app.saveModel();
						newconcept=M4Interface.getCurrentCase().getConcept(conceptname);
						
						MiningMartConcepts concepts=app.getMiningMartConcepts();
						concepts.createMiningMartConcept(concepts,newconcept,app.getPointforConcept());
						MiningMartApplication.m4Interface.releaseCaseWithoutStoring(thecase.getName());
					}catch(M4Exception error){
						M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
					}
				}
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_CONCEPTFROMCASE")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_CONCEPTFROMCASE"))));

/*		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_SUBCONCEPT"),
				parent,
				false) {
			public void execute() {
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_SUBCONCEPT")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_SUBCONCEPT"))));

		menu.addSeparator();
//===============================================================================================================================

	  cmd =
		  new AbstractCommand(
			  Resource.getString("MENU_INSERT_RELATION"),
			  parent,
			  false) {
		  public void execute() {
		  }
	  };
	  menu.add(
		  cmd,
		  new MenuShortcut(Resource.getChar("MENUM_INSERT_RELATION")),
		  new ImageIcon(
			  kit.loadImageResource(
				  Resource.getString("MENU_ICON_INSERT_RELATION"))));


		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_PROJECTION"),
				parent,
				false) {
			public void execute() {
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_PROJECTION")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_PROJECTION"))));*/

		menu.addSeparator();

		IconCommandMenu chain =
			new IconCommandMenu(Resource.getString("MENU_INSERT_CHAIN"));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_CHAIN"),
				parent,
				false) {
			public void execute() {
				Point point = app.getPointforOperator();
				int x = point.x, y = point.y;
				ModelFigureElement p = app.getPotentialParent(x, y);
				if (!(p instanceof Model)) {
					//Als Elternknoten sollte p ein Modell sein
					// falls nicht liegt ein Fehle vor.
//					System.out.println("Fehler in potentialparent");
					return;
				}

				MiningMartChain s = null;

				if (p instanceof MiningMartCase) {
					s =
						((MiningMartCase) p).createMiningMartChain(
							p,
							Resource.getString("CHAIN"),
							point,
							new java.awt.Rectangle(x, y, 35, 35));
				}else if (p instanceof MiningMartChain) {
					s =
						((MiningMartChain) p).createMiningMartChain(
							p,Resource.getString("CHAIN"),
							point,
							new java.awt.Rectangle(x, y, 35, 35));
				}
				else{
//					System.out.println("p ist kein Case und keine Chain");
				}
				parent.toolDone();
				if (s != null)
					parent.selectFigure(s);
					
				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("INSERTED_NEW_CHAIN")+" "+s.getName());

			}
		};
		chain.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_CHAIN")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_NEW_CHAIN"))));

		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_MERGE_CHAIN"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).promptMergeChain();
			}
		};
		chain.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_MERGE_CHAIN")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_MERGE_CHAIN"))));



		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_UNMERGE_CHAIN"),
				parent,
				false) {
			public void execute() {
				((MiningMartApplication) parent).promptUnmergeChain();
			}
		};
		chain.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_UNMERGE_CHAIN")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_UNMERGE_CHAIN"))));

		menu.add(chain);
		cmd =
			new AbstractCommand(
				Resource.getString("MENU_INSERT_TRANSITION"),
				parent,
				false) {
			public void execute() {
					//zwei ausgewaehlte Figuren miteinander verbinden!
					
				FigureEnumeration enum1=app.getMainPane().getDrawingView().selection();

				ModelFigureElement[] elements=new ModelFigureElement[2];

				int index=0;

				while ((enum1.hasNextFigure())&&(index<2)){

					elements[index]=((ModelFigure) enum1.nextFigure()).getElement();
					index++;
				}		
				if (index!=2){
					//You have to select two figures
					return;
				}
				
				Model parentmodel=elements[0].getModel();
				StepTransition trans=null;

				boolean existstrans=false;
				StepTransition exists;				
				for(int c=0;((c<parentmodel.getConnectionCount())&&(!existstrans));c++){
					exists=(StepTransition) parentmodel.getConnection(c);
					if ((exists.getStart().getName().equals(elements[0].getName()))&&
						(exists.getEnd().getName().equals(elements[1].getName()))){
					
						existstrans=true;
					}
				}
				
				if (parentmodel instanceof MiningMartCase){
					trans= ((MiningMartCase) parentmodel).createTransition(null,elements[0],elements[1], existstrans);
					trans.setMMartApplication(((MiningMartCase) parentmodel).getMMartApplication());
					((MiningMartCase) parentmodel).addStepTransition(trans);					
//Listener sind schon informiert					app.getModel().fireCreateConnection(parentmodel,trans);
				}
				else if (parentmodel instanceof MiningMartChain){
					trans= ((MiningMartChain) parentmodel).createTransition(null,elements[0],elements[1],existstrans);
					trans.setMMartApplication(((MiningMartChain) parentmodel).getMMartApplication());					
					((MiningMartChain) parentmodel).addStepTransition(trans);					
//Listener sind schon informiert				app.getModel().fireCreateConnection(parentmodel,trans);
				}
				else{
					//do nothing we have no more models
				}
					
				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("CREATED_NEW_TRANSITION")+" "+trans.getName());
				
				
					
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_TRANSITION")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_TRANSITION"))));


		cmd = new AbstractCommand(Resource.getString("MENU_INSERT_ALL_TRANSITIONS"),	parent,false) {
			public void execute() {
				((MiningMartApplication) parent).promptShowAllTransitions();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_ALL_TRANSITIONS")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_ALL_TRANSITIONS"))));


		menu.addSeparator();

		cmd = new AbstractCommand(Resource.getString("MENU_INSERT_SHOW_STEPSETTINGS"),	parent,false) {
			public void execute() {
				((MiningMartApplication) parent).showStepSettings();
			}
		};
		menu.add(
			cmd,
			new MenuShortcut(Resource.getChar("MENUM_INSERT_SHOW_STEPSETTINGS")),
			new ImageIcon(
				kit.loadImageResource(
					Resource.getString("MENU_ICON_INSERT_SHOW_STEPSETTINGS"))));


		operatorsmenu=createOperatorMenu();

		menu.add(createOperatorMenu());

		return menu;

	}
	
	public IconCommandMenu getOperatorsMenu(){
		return operatorsmenu;
	}

	public IconCommandMenu createOperatorMenu() {
		Iconkit kit = Iconkit.instance();

		//JMenu menu=new JMenu(Resource.getString("MENU_OPERATORS"));
		IconCommandMenu menu =
			new IconCommandMenu(Resource.getString("MENU_OPERATORS"));

		menu = getOpGroups(menu);

		return menu;
	}

	/**
	 * Creates operator groups from the database table specification.
	 * @param topLevel the <code>CoComponentList</code> holding the operator menu
	 * @return <code>true</code> iff creating the menu succeeded
	 * */
	private IconCommandMenu getOpGroups(IconCommandMenu topLevel) {
		M4Interface m4i = M4Interface.getInstance();
		if (m4i != null) {
			OperatorGroup opg = m4i.getOperatorGroup();
			Collection c = opg.getTopLevelOperatorGroups();			
			if (c == null || c.isEmpty()) {
				System.err.println("Fatal error: no operator groups found in M4 schema.");
				System.exit(-1);
			}
			Iterator it = c.iterator();
			while (it.hasNext()) {
				Long opgId = (Long) it.next();
				try {
					topLevel.add(this.recurseThroughInsertOps(opgId, opg));
				} catch (M4Exception e) {
					M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
					return null;
				}
			}
		}
		return topLevel;
	}

	/** Helper method iterating through an operator group specified in the database */
	private IconCommandMenu recurseThroughInsertOps(
		Long opGroupId,
		OperatorGroup opg)
		throws M4Exception {
		// the opGroupId belongs to an operator group (inner node), so just create
		// an according folder:
		String name = opg.getGroupName(opGroupId);
		IconCommandMenu cclist = this.getInsertItemFolder(name);

		// Iterate through the contained elements:
		Collection col = opg.getChildGroups(opGroupId);
        /*
         * Joerg, 2006-05-03: Check for null value.
         */
        if (col != null) {
    		Iterator it = col.iterator();
    		while (it.hasNext()) {
    			Long idNext = (Long) it.next();
    
    			// Test whether idNext represents an inner node or an operator:
    			Collection down = opg.getChildGroups(idNext);
    			if (down != null) { // "down" represents an inner node, recurse!
    				cclist.add(this.recurseThroughInsertOps(idNext, opg));
    			} else { // "down" represents an operator, just add it to the folder!
    				Operator op = opg.getOperator(idNext);
    				if (op != null) {
    					String opName = op.getName();
    					AbstractCommand cmd = this.getInsertItemForOperator(opName);
    					cclist.add(
    						cmd,
    						getMenuShortCutForOperator(opName),
    						getImageIconForOperator(opName));
    				}
    			}
    		}
        }
		return cclist;
	}

	private ImageIcon getImageIconForOperator(String opName) {
		Iconkit kit = Iconkit.instance();
		ImageIcon icon = null;
		try {
			icon =
				new ImageIcon(
					kit.loadImageResource(
						Resource.getString(
							"MENU_ICON_OP_" + opName.toUpperCase())));
		} catch (NullPointerException e) {
			icon =
				new ImageIcon(
					kit.loadImageResource(
						Resource.getString("MENU_ICON_OP_GENERICOPERATOR")));
		}
		return icon;
	}

	/** Helper method: creates a Menushortcut for the operator */
	private MenuShortcut getMenuShortCutForOperator(String opName) {
		return new MenuShortcut(
			Resource.getChar("MENUM_OP_" + opName.toUpperCase()));
	}
	/** Helper method: creates a folder for the InsertOperator menu */
	private IconCommandMenu getInsertItemFolder(String name) {
		IconCommandMenu subList = new IconCommandMenu(name);
		//	    subList.getIcons().add(0, CoUtil.getIcon("empty.gif", new Class[] {MrfcOperator.class,Application.class}));
		return subList;
	}

	/** Helper method: creates an item for the InsertOperator menu */
	private AbstractCommand getInsertItemForOperator(String operatorName) {
		//ActionInsertOperator actionInsertOperator = new ActionInsertOperator(actionClass, "GenericOperator", operatorName);
		AbstractCommand compItem =
			new AbstractCommand(operatorName, parent, false) {

			public void execute() {
//				M4Interface.print.doPrint(Print.MAX, "New Operator-Menu-Item  inserted for Operator: " + name());

				Point point = app.getPointforOperator();
				int x = point.x, y = point.y;
				ModelFigureElement p = app.getPotentialParent(x, y);
				if (!(p instanceof Model)) {
					//Als Elternknoten sollte p ein Modell sein
					// falls nicht liegt ein Fehle vor.
					M4Interface.print.doPrint(Print.ERROR,"The potential parent must be a model!");
					return;
				}

				MiningMartStep s = null;

				if (p instanceof MiningMartChain) {

					s =
						((MiningMartChain) p).createMiningMartStep(
							p,
							this.name(),
							null,
							point,
							new java.awt.Rectangle(x, y, 35, 35));
				}
				//editor().toolDone();
				parent.toolDone();
				if (s != null){
					parent.selectFigure(s);
					M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("INSERTED_OPERATOR")+" "+s.getName());
				}

			}
		};

		return compItem;
	}
	
	private class CheckBoxListener implements ActionListener{
		
		public JCheckBoxMenuItem box;
		
		public CheckBoxListener(JCheckBoxMenuItem box){
			this.box=box;
		}
		
		public void actionPerformed(ActionEvent event){
		}
	}
	
	private class RadioButtonListener implements ActionListener{
		
		private JRadioButtonMenuItem button;
		
		public RadioButtonListener(JRadioButtonMenuItem button){
			this.button=button;
		}

		public void actionPerformed(ActionEvent event){
		}
		
	}

}
/*
$Log: MiningMartMenuBar.java,v $
Revision 1.16  2006/10/06 14:11:30  euler
compiles now also under Java 1.5

Revision 1.15  2006/09/27 15:00:01  euler
New version 1.1

Revision 1.14  2006/09/21 14:26:43  euler
*** empty log message ***

Revision 1.13  2006/09/05 20:38:15  euler
*** empty log message ***

Revision 1.12  2006/08/10 14:38:02  euler
New mechanism for reversing steps

Revision 1.11  2006/05/05 07:39:09  euler
Bugfix by Joerg Pleumann

Revision 1.10  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.9  2006/04/06 16:31:14  euler
Prepended license remark.

Revision 1.8  2006/03/31 15:22:20  euler
*** empty log message ***

Revision 1.7  2006/03/30 11:30:34  euler
Moved garbage collection from tools menu to compile menu.

Revision 1.6  2006/03/29 11:16:44  euler
Still more robust when installing.

Revision 1.5  2006/03/24 14:19:31  euler
Added concept links preferences

Revision 1.4  2006/03/22 13:08:52  euler
*** empty log message ***

Revision 1.3  2006/01/10 07:51:58  hakenjos
Save the model befoire switching to Concept- or Case-Editor.

Revision 1.2  2006/01/05 07:41:25  hakenjos
MiningMart can now export the drawing of a model as an image (eps,png,jpg).
Case -> Export Image...

Revision 1.1  2006/01/03 09:54:27  hakenjos
Initial version!

*/
