/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.util.Vector;

import org.musoft.limo.application.Application;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;

import edu.udo.cs.miningmart.gui.figures.ChainFigure;
import edu.udo.cs.miningmart.gui.figures.ConceptFigure;
import edu.udo.cs.miningmart.gui.figures.FeatureFigure;
import edu.udo.cs.miningmart.gui.figures.ProjectionFigure;
import edu.udo.cs.miningmart.gui.figures.RelationFigure;
import edu.udo.cs.miningmart.gui.figures.StepFigure;
import edu.udo.cs.miningmart.gui.figures.SubConceptFigure;
import edu.udo.cs.miningmart.gui.figures.TransitionFigure;
import edu.udo.cs.miningmart.gui.model.MiningMartBaseAttribute;
import edu.udo.cs.miningmart.gui.model.MiningMartCase;
import edu.udo.cs.miningmart.gui.model.MiningMartChain;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartMultiColumnFeature;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;


/**
 * This is the <code>ModelDrawing</code> for MiningMart.
 * You can add figures for <code>ModelFigureElement</code>s and <code>ModelConnection</code>s.
 * 
 * @author Daniel Hakenjos
 * @version $Id: MiningMartDrawing.java,v 1.4 2006/09/27 15:00:02 euler Exp $
 */
public class MiningMartDrawing extends ModelDrawing implements ModelListener {


    private MiningMartApplication application;
    
	private Vector activeElements = new Vector(); 
	
	
	/**
	 * Constructor for MiningMartDrawing.
	 */
	public MiningMartDrawing(MiningMartApplication app, MiningMartCase root) { 
        super(root);
        application = app;
	}


	/**
	 * Constructor for MiningMartDrawing.
	 */
	public MiningMartDrawing(MiningMartApplication app, MiningMartChain root) { 
        super(root);
        application = app;
	}
	
	/**
	 * Constructor for MiningMartConcepts.
	 */
	public MiningMartDrawing(MiningMartApplication app,MiningMartConcepts root){
		super(root);
		application = app;
	}


	/**
	 * @see org.musoft.limo.model.ModelDrawing#onCreateChild(ModelFigureElement,ModelElement)
	 */
	public void onCreateChild(ModelFigureElement sender, ModelElement child) {

        /*
         * Muesste eine Art zentraler Factory fuer Figuren werden oder eine
         * solche benutzen, wenn das Festlegen von Wurzel/Tiefe klappen soll.
         * Problem: Wenn die Wurzel nicht das Modell selbst ist, dann werden
         * an dieser Stelle nicht mehr Kapseln und Protokolle erzeugt, sondern
         * Ports und Instanzen. Weiteres Problem: Positionen und Groessen.
         * Elemente tieferer Ebenen werden mitverschoben, obwohl das gar nicht
         * passieren soll (setPosition() des StateCharts so ueberschreiben, dass
         * es die Aenderung nicht nach unten reicht). Factory sollte eigenes
         * Objekt
         * sein, damit sie bei Jens geeignet aenderbar ist.
         */  
      /**   
         *System.out.println("\n"+sender.toString()+"\n");   
         *System.out.println("\nMiningMartCase"+(sender instanceof MiningMartCase)+"\n");   
         *System.out.println("\nMiningMartStep"+(sender instanceof MiningMartStep)+"\n");   
         *System.out.println("\nMiningMartChain"+(sender instanceof MiningMartChain)+"\n"); 
         */
         
         Model model=this.getModel();
         
		if ((child instanceof MiningMartStep) && (model instanceof MiningMartChain)){
			add(new StepFigure((MiningMartStep) child,this));
			this.invalidate();
		}else if ((child instanceof MiningMartChain)&& (model instanceof Model)){
			add(new ChainFigure((MiningMartChain) child,this));
			this.invalidate();
		}else if ((child instanceof MiningMartConcept) && (model instanceof MiningMartConcepts)){
			add(new ConceptFigure((MiningMartConcept) child,this));
			this.invalidate();
		}else if ((child instanceof MiningMartBaseAttribute) && (sender instanceof MiningMartConcept)){
			add(new FeatureFigure((MiningMartBaseAttribute) child,this));
			this.invalidate();
		}else if ((child instanceof MiningMartMultiColumnFeature) && (sender instanceof MiningMartConcept)){
			add(new FeatureFigure((MiningMartMultiColumnFeature) child,this));
			this.invalidate();
		}
		
	}

	/**
	 * @see org.musoft.limo.model.ModelDrawing#onCreateChild(Model,ModelConnectionElement)
	 */
	public void onCreateConnection(Model model, ModelConnectionElement connection) {
        if (connection instanceof StepTransition) {
            try {
                ModelConnection figure = new TransitionFigure(this, connection);
                figure.setLabel(null);
                add(figure);
                figure.updateConnection();
                
                /*
                 * Die folgenden beiden Zeilen ueberlisten die automatische Positions-
                 * anpassung der JHotDraw-Labels und sorgen dafuer, dass die gespeicherten
                 * Werte tatsaechlich benutzt werden.
                 */
                figure.setLabelPosition(ModelConnection.LABEL_HIDDEN);
                // if (figure.getLabel() != null) figure.setLabelPosition(ModelConnection.LABEL_CENTER);
            }
            catch (Exception e) {
            	M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
            }
        }else if(connection instanceof MiningMartSubConcept){
			try {
				ModelConnection figure = new SubConceptFigure(this, connection);
                figure.setLabel(null);
				add(figure);
				figure.updateConnection();
                
				figure.setLabelPosition(ModelConnection.LABEL_HIDDEN);
			}
			catch (Exception e) {
				M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
			}
        }else if (connection instanceof MiningMartRelation){
			try {
				ModelConnection figure = new RelationFigure(this, connection);
                figure.setLabel(null);
				add(figure);
				figure.updateConnection();
                
				figure.setLabelPosition(ModelConnection.LABEL_HIDDEN);
				//if (figure.getLabel() != null) 
				// 	figure.setLabelPosition(ModelConnection.LABEL_CENTER);
			}
			catch (Exception e) {
				M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
			}
        }else if (connection instanceof MiningMartProjection){
			try {
				ModelConnection figure = new ProjectionFigure(this, connection);
                figure.setLabel(null);
				add(figure);
				figure.updateConnection();
				figure.setLabelPosition(ModelConnection.LABEL_HIDDEN);
				// if (figure.getLabel() != null) figure.setLabelPosition(ModelConnection.LABEL_CENTER);
			}
			catch (Exception e) {
				M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
			}
        }
	}
	
	/**
	 * @see org.musoft.limo.model.ModelListener#onDestroy(ModelElement)
	 */
	public void onDestroy(ModelElement sender) {
		if (application.getViewMode()==Application.EDITOR){
			super.onDestroy(sender);
		}
	}

}
/*
$Log: MiningMartDrawing.java,v $
Revision 1.4  2006/09/27 15:00:02  euler
New version 1.1

Revision 1.3  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
