/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A dialog for viewing the log-file.
 * @author Daniel Hakenjos
 * @version $Id: LogFileViewer.java,v 1.4 2006/09/27 15:00:01 euler Exp $
 */
public class LogFileViewer extends JDialog implements ActionListener,TreeSelectionListener{

	private JTextArea textarea;

	private JButton close_button;

	private String logtext;
	
	private Vector sessions;
	
	private JTree sessiontree;
	
	private class Session{
		
		private String description, text;
		
		public Session(String description, String text){
			this.description=description;
			this.text=text;
		}
		
		public String getDescription(){
			return description;
		}
		
		public String getText(){
			return text;
		}
		
		public String toString(){
			return description;
		}
		
	}
	
	public LogFileViewer(Frame owner){
		super(owner, Resource.getString("LOGFILEVIEWER_TITLE"), true);
		loadLogFile();
		initComponents();
	}
	
	
	private void initComponents(){
		JSplitPane splitpane=new JSplitPane();
		splitpane.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
		splitpane.setDividerLocation(225);
		
		DefaultMutableTreeNode top =
			new DefaultMutableTreeNode(Resource.getString("SESSIONS"),true);
		createTreeNodes(top);
		
		sessiontree=new JTree(top);
		MyTreeCellRenderer treerenderer=new MyTreeCellRenderer();
		sessiontree.setCellRenderer(treerenderer);
		sessiontree.addTreeSelectionListener(this);
		
		JScrollPane scrollpane1 = new JScrollPane(sessiontree);
		splitpane.setLeftComponent(scrollpane1);
		
		textarea=new JTextArea();
		textarea.setText("");
		textarea.setEditable(false);
		textarea.setForeground(Color.black);
		textarea.setBackground(Color.white);
		JScrollPane scrollpane=new JScrollPane(textarea);
		splitpane.setBottomComponent(scrollpane);
		
		JPanel toppanel=new JPanel();
		toppanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		toppanel.setLayout(new BorderLayout());
		toppanel.add(splitpane,BorderLayout.CENTER);
		this.getContentPane().add(toppanel);
		
		JPanel buttonpanel=new JPanel();
		buttonpanel.setLayout(new BorderLayout());
		toppanel.add(buttonpanel,BorderLayout.SOUTH);
		
		close_button=new JButton(Resource.getString("CLOSE"));
		close_button.addActionListener(this);
		buttonpanel.add(close_button,BorderLayout.EAST);

		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		pack();
		setSize(800, 600);

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);

		setVisible(true);
	}

	private void createTreeNodes(DefaultMutableTreeNode top) {
		DefaultMutableTreeNode treenode;
		Session session;
		for (int i = 0; i < sessions.size(); i++) {
			session=(Session) sessions.get(i);
			treenode =new DefaultMutableTreeNode(session,false);
			top.add(treenode);
		}
	}

	private void loadLogFile(){
		File logfile=Print.getLogFile();
		sessions=new Vector();
		
		logtext=new String();
		try{
			LineNumberReader reader=new LineNumberReader(new FileReader(logfile));
			
			String logfiletext="";
			String line=reader.readLine();
			while (line!=null){
				if (line.equals("")){
					line=reader.readLine();				
					continue;
				}
				if ((line.indexOf("MiningMart Version")>0)&&(line.indexOf("exit")>0)){
					String description=logfiletext.substring(0,logfiletext.indexOf("M:")+1);
					description.replace('\n',' ');
					
					Session session=new Session(description,logfiletext);
					sessions.add(session);
					
					logtext+=logfiletext+"\n";
					line=reader.readLine();				
					logfiletext="";
					continue;
				}
				logfiletext+=line+"\n";
				line=reader.readLine();				
			}
			//die letzten Zeilen noch anhaengen
			String description=logfiletext.substring(0,logfiletext.indexOf("M:")+1);
			description.replace('\n',' ');
					
			Session session=new Session(description,logfiletext);
			sessions.add(session);
			logtext+=logfiletext+"\n";

		}catch(FileNotFoundException error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			logtext="";	
		}catch(IOException error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}


	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		dispose();
	}

	private class MyTreeCellRenderer extends DefaultTreeCellRenderer {

		private Icon sessions,session;

		public MyTreeCellRenderer() {
			Iconkit kit = Iconkit.instance();

			sessions =
				new ImageIcon(
					kit.loadImageResource(Resource.getString("SESSIONS_ICON")));
			session =
				new ImageIcon(
					kit.loadImageResource(
						Resource.getString("SESSION_ICON")));
		}

		public Component getTreeCellRendererComponent(
			JTree tree,
			Object value,
			boolean sel,
			boolean expanded,
			boolean leaf,
			int row,
			boolean hasFocus) {

			DefaultMutableTreeNode treenode = (DefaultMutableTreeNode) value;

			super.getTreeCellRendererComponent(
				tree,
				value,
				sel,
				expanded,
				leaf,
				row,
				hasFocus);
				
			if (treenode.isRoot()){
				setIcon(sessions);
				return this;
			}
			setIcon(session);

			return this;
		}

	}

	/**
	 * Gets the selected TreeNode.
	 */
	public MutableTreeNode getSelectedTreeNode(){
		TreePath path=sessiontree.getSelectionPath();
		if (path==null)
			return (MutableTreeNode) sessiontree.getModel().getRoot();
		return (MutableTreeNode) path.getLastPathComponent();
	}


	/* (non-Javadoc)
	 * @see javax.swing.event.TreeSelectionListener#valueChanged(javax.swing.event.TreeSelectionEvent)
	 */
	public void valueChanged(TreeSelectionEvent e) {
		MutableTreeNode node=this.getSelectedTreeNode();
	
		if (((DefaultMutableTreeNode) node).isRoot()){
			textarea.setText(logtext);
			return;
		}
	
		Object object=	((DefaultMutableTreeNode) node).getUserObject();
		if (object instanceof Session){
			textarea.setText(((Session) object).getText());
		}
	}

}
/*
 * Historie
 * --------
 *
 * $Log: LogFileViewer.java,v $
 * Revision 1.4  2006/09/27 15:00:01  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:27  hakenjos
 * Initial version!
 *
 */
