/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.model.ModelFigureElement;

import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A <code>JPanel</code> for concept tools.
 * @author Daniel Hakenjos
 * @version $Id: ConceptToolPanel.java,v 1.4 2006/09/27 15:00:01 euler Exp $
 */
public class ConceptToolPanel extends ToolBar{

	private MiningMartApplication app;

	private JPanel stuff_panel, toppanel, toolpanel;
	private JScrollPane scrollpane;
	private JLayeredPane layerpane;
	
	private Vector groups;
	private Vector groupstoolbars;

	/**
	 * Constructor for OperatorToolPanel.
	 */
	public ConceptToolPanel(MiningMartApplication app) {
		super(app);
		this.app=app;

		groups=new Vector();
		groupstoolbars=new Vector();
		initComponents();		
	}
	
	private void initComponents(){

		
		
		initStuffPanel();	
		toolpanel=new JPanel();
		GridLayout grid=new GridLayout(groups.size(),1);
		grid.setHgap(4);
		grid.setVgap(4);
		toolpanel.setLayout(grid);
		

		for (int index=0;index<this.groupstoolbars.size();index++){
			
			String groupname=(String) this.groups.get(index);

			ToolBar toolbar=(ToolBar) groupstoolbars.get(index);
			toolbar.addGroup(groupname);
			toolbar.showGroup(groupname,ToolBar.ACTIVE);
			
			toolbar.setPreferredSize(new Dimension(40,40));
			toolbar.setFloatable(false);
			toolpanel.add(toolbar);

		}		
		JPanel panel2=new JPanel();
		panel2.setLayout(new BorderLayout());
		panel2.add(toolpanel,BorderLayout.NORTH);	
		
		
		scrollpane=new JScrollPane(panel2);
		
		toppanel=new JPanel(){
			public String toString(){
				return Resource.getString("COMP_CONCEPTTOOLS");
			}
		};
		toppanel.setLayout(new BorderLayout());
		toppanel.add(scrollpane,BorderLayout.CENTER);
		
	}
	
	private void initStuffPanel(){
		// use a Mediatracker to ensure that all the images are initially loaded

		Tool tool =new MyAbstractTool(Resource.getString("TOOL_CONCEPT"),parent){
			public void mouseDown(MouseEvent e, int x, int y) {
				super.mouseDown(e, x, y);
				ModelFigureElement p = getPotentialParent(x, y, drawing());
				
				MiningMartConcept s = null;
				
				if (p instanceof MiningMartConcepts){

					NewConceptDialog dialog=new NewConceptDialog(app);
					if (dialog.getExitAction()==dialog.CANCEL){
						editor().toolDone();
						return;
					}

					s = ((MiningMartConcepts) p).createMiningMartConcept(p,dialog.getNewConceptName(), new Point(x,y),dialog.getConceptType());
				}
				else{
					//offensichtlich liegt ein Fehler vor
					editor().toolDone();
					return;
				}
				editor().toolDone();
				if (s != null){
					parent.selectFigure(s);
					M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("INSERTED_NEW_CONCEPT")+" "+s.getName());
				}
			}
		};
		JButton button=createMyToolButton(Resource.getString("TOOLIMG_CONCEPT"), Resource.getString("TOOL_CONCEPT"), tool);
		button.setToolTipText(Resource.getString("TOOL_CONCEPT"));
		add("concept",button);

		// SubConceptTransition erzeugen   
		tool = new SubConceptTransitionTool((MiningMartApplication) parent, MiningMartSubConcept.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");		
		add("concept", createMyToolButton(Resource.getString("TOOLIMG_SUBCONCEPT"), Resource.getString("TOOL_SUBCONCEPT"), tool));

		// RelationTransition erzeugen   
		tool = new RelationTransitionTool((MiningMartApplication) parent, MiningMartRelation.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");		
		add("concept", createMyToolButton(Resource.getString("TOOLIMG_RELATION"), Resource.getString("TOOL_RELATION"), tool));

		// ProjectionTransition erzeugen   
		tool = new ProjectionTransitionTool((MiningMartApplication) parent, MiningMartProjection.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");		
		add("concept", createMyToolButton(Resource.getString("TOOLIMG_PROJECTION"), Resource.getString("TOOL_PROJECTION"), tool));
	}

	/**
	 * Adds a <code>JButton</code> with its groupname.
	 */
	public Component add(String groupname, JButton button){
		
		if (groups.contains(groupname)){
			int index=groups.indexOf(groupname);
			
			ToolBar bar=(ToolBar) groupstoolbars.remove(index);
			
			bar.addButton(groupname,button);
			
			groupstoolbars.insertElementAt(bar,index);
		}
		else{
			groups.add(groupname);
			
			ToolBar bar=new ToolBar(app);
			bar.removeAll();
			
			bar.addButton(groupname,button);
			
			groupstoolbars.add(bar);
		}	
		
		return button;
		
	}
	
	/**
	 * Gets the <code>JPanel</code> with the preferred operators.
	 */
	public JPanel getConceptToolPanel(){
		return this.toppanel;
	}
	
	private class MyAbstractTool extends AbstractTool{

		private String name;

		public MyAbstractTool(String name, DrawingEditor drawingeditor){
			super(drawingeditor);
			this.name=name;
		}
		
		public String getName(){
			return name;
		}
	}
}
/*
 * Historie
 * --------
 *
 * $Log: ConceptToolPanel.java,v $
 * Revision 1.4  2006/09/27 15:00:01  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:26  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.4  2005/12/06 08:53:14  hakenjos
*** empty log message ***

Revision 1.3  2005/08/23 09:03:03  hakenjos
*** empty log message ***

Revision 1.2  2005/07/19 14:20:55  hakenjos
*** empty log message ***

Revision 1.1  2005/07/19 12:18:06  hakenjos
*** empty log message ***

*/
