/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.M4Interface.CaseLockedException;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Daniel Hakenjos
 * @version  $Id: ConceptFromCaseDialog.java,v 1.4 2006/09/27 15:00:01 euler Exp $
 */
public class ConceptFromCaseDialog
	extends JDialog
	implements ActionListener, ListSelectionListener {

	public final int CANCEL = 0;
	public final int OK = 1;

	private int exitAction;

	private JButton ok, cancel;

	private JList cases,concepts;

	private String thecase,concept;
	
	private Case the_case = null;

	private String[] casenames, conceptnames;

	public ConceptFromCaseDialog(MiningMartApplication parent) {
		super(
			parent,
			Resource.getString("DIALOG_CONCEPTFROMCASE_TITLE"),
			true);

		this.exitAction = CANCEL;
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		this.pack();

		setSize(450, 300);

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);
	}

	/**
	 * Inits the components.
	 */
	public void initComponents() {

		JPanel top_panel = new JPanel();
		top_panel.setLayout(new BorderLayout(5, 5));

		cancel = new JButton(Resource.getString("CANCEL"));
		ok = new JButton(Resource.getString("OK"));
		ok.setEnabled(false);

		cancel.addActionListener(this);
		ok.addActionListener(this);

		Collection coll = null;
		try {
			coll = MiningMartApplication.m4Interface.getAllCaseNames();
		}
		catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
		if (coll == null) return;
		Iterator iter = coll.iterator();
		casenames = new String[coll.size()-1];
		int index = 0;
		String next;
		while (iter.hasNext()) {
			next= (String) iter.next();
			if (next.equals(M4Interface.getCurrentCase().getName())){
				next= (String) iter.next();
			}
			casenames[index] =next;
			index++;
		}

		cases = new JList(casenames);
		cases.addListSelectionListener(this);
		JScrollPane scrollpane = new JScrollPane(cases);
		JPanel casepanel=new JPanel();
		casepanel.setLayout(new BorderLayout());
		casepanel.add(scrollpane, BorderLayout.CENTER);

		JLabel label =	new JLabel(Resource.getString("DIALOG_CONCEPTFROMCASE_CASE"));
		casepanel.add(label, BorderLayout.NORTH);


		concepts = new JList(new String[0]);
		concepts.addListSelectionListener(this);
		scrollpane = new JScrollPane(concepts);
		JPanel conceptpanel=new JPanel();
		conceptpanel.setLayout(new BorderLayout());
		conceptpanel.add(scrollpane, BorderLayout.CENTER);

		label =	new JLabel(Resource.getString("DIALOG_CONCEPTFROMCASE_CONCEPT"));
		conceptpanel.add(label, BorderLayout.NORTH);
		
		JPanel listpanel=new JPanel();
		listpanel.setLayout(new GridLayout(1,2,5,5));
		listpanel.add(casepanel);
		listpanel.add(conceptpanel);
		
		top_panel.add(listpanel, BorderLayout.CENTER);

		JPanel bottom = new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(ok);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);
		top_panel.add(bottom, BorderLayout.SOUTH);

		top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		this.getContentPane().add(top_panel);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();
		if (cmd.equals(Resource.getString("CANCEL"))) {
			exitAction = CANCEL;
			this.dispose();
		}
		if (cmd.equals(Resource.getString("OK"))) {
			exitAction = OK;
			thecase=(String) cases.getSelectedValue();
			concept = (String) concepts.getSelectedValue();
			this.dispose();
		}
	}

	/* (non-Javadoc)
	 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
	 */
	public void valueChanged(ListSelectionEvent e) {
		Object src=e.getSource();
		if ((src.equals(cases))&&(!cases.isSelectionEmpty())){
			thecase=(String) cases.getSelectedValue();
			try{
				if (the_case == null) {
					M4Interface.print.doPrint(Print.ERROR,"valueChanged called");
					the_case=MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(thecase,false);
				}
				else {
					if ( ! the_case.getName().equals(thecase)) {
						M4Interface.print.doPrint(Print.ERROR,"valueChanged called");
						MiningMartApplication.m4Interface.releaseCaseWithoutStoring(the_case.getName());
						the_case=MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(thecase,false);						
					}
				}
				Object[] obj=the_case.getAllConceptNames().toArray();
				
				conceptnames=new String[obj.length];
				for(int i=0;i<obj.length;i++){
					conceptnames[i]=(String) obj[i];
				}
				concepts.setListData(conceptnames);
			}catch(CaseLockedException error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}catch(M4Exception error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
		}
		
		if ((!cases.isSelectionEmpty())&&(!concepts.isSelectionEmpty())) {
			ok.setEnabled(true);
		} else {
			ok.setEnabled(false);
		}
	}

	/**
	 * Gets the exit-action.
	 */
	public int getExitAction() {
		return exitAction;
	}

	/**
	 * Gets the case.
	 */
	public Case getTheCase() {
		if (exitAction == OK)
			return the_case;
		return null;
	}

	/**
	 * Gets the name of the concept.
	 */
	public String getConceptName(){
		if (exitAction == OK)
			return concept;
		return null;
	}
}
/*
 * Historie
 * --------
 *
 * $Log: ConceptFromCaseDialog.java,v $
 * Revision 1.4  2006/09/27 15:00:01  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:15  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:27  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.4  2005/08/25 08:20:27  hakenjos
*** empty log message ***

Revision 1.3  2005/08/24 09:02:23  euler
Bugfix

Revision 1.2  2005/08/24 08:40:04  euler
Bugfixes

Revision 1.1  2005/08/23 09:03:03  hakenjos
*** empty log message ***

*/
