/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/**
 * This panel is added to the preferences to enable the user to specify
 * which types of links between concepts should be drawn (subconcept links,
 * projections and/or relationships). 
 * 
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: ConceptEditorPreferencesPanel.java,v 1.6 2006/09/27 15:00:01 euler Exp $
 */
public class ConceptEditorPreferencesPanel extends PreferencesPanel {

	private JCheckBox boxDrawSubconc;
	private JCheckBox boxDrawProj;
	private JCheckBox boxDrawRel;	
	
	private boolean drawSubconcepts = true;
	private boolean drawProjections = true;
	private boolean drawRelationships = true;
	
	// private int anzahl;
	
	private MiningMartApplication app;

	public ConceptEditorPreferencesPanel(MiningMartApplication app){
		this.app=app;
		
		// anzahl=app.getNumberOfFeatures();
		this.drawProjections = this.app.shouldDrawProjections();
		this.drawRelationships = this.app.shouldDrawRelationships();
		this.drawSubconcepts = this.app.shouldDrawSubconceptLinks();
		
		initComponents();
	}
	
	/**
	 * Inits the components
	 */
	private void initComponents(){
		
		JPanel panel=new JPanel();
		panel.setLayout(new BorderLayout(5,5));

		String textSubconc = "Draw subconcept links";
		String textProj = "Draw projections";
		String textRels = "Draw relationships";
		
		// JLabel labelDrawSubconc=new JLabel(textSubconc);
		// JLabel labelDrawProj=new JLabel(textProj);
		// JLabel labelDrawRels=new JLabel(textRels);

		this.boxDrawSubconc = new JCheckBox(textSubconc, this.drawSubconcepts);
		this.boxDrawProj = new JCheckBox(textProj, this.drawProjections);
		this.boxDrawRel = new JCheckBox(textRels, this.drawRelationships);
		
		panel.add(boxDrawSubconc, BorderLayout.NORTH);
		panel.add(boxDrawProj, BorderLayout.CENTER);
		panel.add(boxDrawRel, BorderLayout.SOUTH);
		
		setLayout(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		add(panel,BorderLayout.NORTH);		
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionCancel()
	 */
	public void actionCancel() {
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionOK()
	 */
	public void actionOK() {
		actionSave();
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionSave()
	 */
	public void actionSave() {
		this.drawProjections = this.boxDrawProj.isSelected();
		this.drawRelationships = this.boxDrawRel.isSelected();
		this.drawSubconcepts = this.boxDrawSubconc.isSelected();
		this.app.setWhichLinksToDraw(this.drawSubconcepts, this.drawRelationships, this.drawProjections);
	}

}
/*
 * Historie
 * --------
 *
 * $Log: ConceptEditorPreferencesPanel.java,v $
 * Revision 1.6  2006/09/27 15:00:01  euler
 * New version 1.1
 *
 * Revision 1.5  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:15  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/24 14:38:35  euler
 * *** empty log message ***
 *
 * Revision 1.2  2006/03/24 14:19:31  euler
 * Added concept links preferences
 *
 * Revision 1.1  2006/01/03 09:54:26  hakenjos
 * Initial version!
 *
 */
