/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.compiler.M4CompilerInterfaceError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A <code>Thread</code> to run the compilation.
 * @author Daniel Hakenjos
 * @version $Id: CompilerThread.java,v 1.6 2006/09/27 15:00:01 euler Exp $
 */
public class CompilerThread extends Thread {

	public static final int COMPILE_STEP = 0;

	public static final int COMPILE_FROM_STEP = 1;

	public static final int COMPILE_UNTIL_STEP = 2;

	public static final int COMPILE_ALL = 3;

	private MiningMartApplication app;

	private int task;

	private long stepId;

	public CompilerThread(MiningMartApplication app, int task, long stepId) {
		this.app = app;
		this.task = task;
		this.stepId = stepId;
	}

	/**
	 * Kills the compilation.
	 */
	public void killCompilation() {
	}

	/**
	 * Runs the CompilerThread.
	 */
	public void run() {
		
		((MiningMartMenuBar) app.getJMenuBar()).promptStartCompilationItemStates();
		((MiningMartToolBar) app.getToolbar()).promptStartCompilationItemStates();
		try {
			if (task == COMPILE_STEP) {
				runCompileStep();
			} else if (task == COMPILE_FROM_STEP) {
				runCompileFrom();
			} else if (task == COMPILE_UNTIL_STEP) {
				runCompileUntil();
			} else if (task == COMPILE_ALL) {
				runCompileAll();
			} else {
			//	wrong task do nothing
			}
		}
		catch (M4CompilerWarning warn) {
			JOptionPane.showMessageDialog(app,
					warn.getMessage(), 
					Resource.getString("COMPILE_WARNING_TITLE"),
					JOptionPane.WARNING_MESSAGE);
		}	
		catch (M4CompilerInterfaceError ce) {
			JOptionPane.showMessageDialog(app,
					ce.getMessage(), 
					Resource.getString("COMPILE_ERROR_UNTIL_STEP"),
					JOptionPane.ERROR_MESSAGE);
		}	
		catch (UserError ue) {
			M4Interface.print.doPrint(Print.ERROR, ue.getMessage());
			JOptionPane.showMessageDialog(null, // Application.frame
					ue.getMessage(), "Runtime condition violated",
					JOptionPane.ERROR_MESSAGE);
		}		
		catch (Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(), error);
		}
	    
		M4Interface.print.doPrint(
			Print.COMPILER_CASE_CONTROL,
			Resource.getString("COMPILING_DONE"));
		((MiningMartMenuBar) app.getJMenuBar()).promptDoneCompilationItemStates();
		((MiningMartToolBar) app.getToolbar()).promptDoneCompilationItemStates();
	}

	private void runCompileStep() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
		app.getCompilerAccess().compileStep(stepId, MiningMartApplication.compileLazy);
	}

	private void runCompileFrom() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
		app.getCompilerAccess().compileStepFrom(stepId, MiningMartApplication.compileLazy);		
	}

	private void runCompileUntil() throws UserError, M4CompilerWarning, M4CompilerInterfaceError{
		app.getCompilerAccess().compileStepTo(stepId, MiningMartApplication.compileLazy, true);		
	}

	private void runCompileAll() throws UserError, M4CompilerWarning, M4CompilerInterfaceError {
		app.getCompilerAccess().compileAll(
				M4Interface.getCurrentCase().getId(),
				MiningMartApplication.compileLazy);
	}

}
/*
$Log: CompilerThread.java,v $
Revision 1.6  2006/09/27 15:00:01  euler
New version 1.1

Revision 1.5  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.4  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.3  2006/03/23 11:13:46  euler
Improved exception handling.

Revision 1.2  2006/03/19 21:16:11  scholz
Violated compiler conditions are displayed now.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
