/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;



/**
 * A simple AboutDialog.
 * For changes overwrite <code>setInfoText()</code>.
 * @author Daniel Hakenjos
 * @version $Id: AboutDialog.java,v 1.6 2006/09/27 15:00:01 euler Exp $
 */
public class AboutDialog extends JDialog {

	/**
	 * @param owner The <code>MiningMartApplication</code>.
	 * @throws java.awt.HeadlessException
	 */
	public AboutDialog(MiningMartApplication owner) throws HeadlessException {
		// owner, Titel, modal
		super(owner,Resource.getString("DLG_ABOUT"),true);
		
		// gerahmtes Panel
		JPanel content = new JPanel();
		content.setLayout( new GridLayout(2,1) );
		Border space = BorderFactory.createEmptyBorder(10, 10, 10, 10);
		Border frame = BorderFactory.createEtchedBorder();
		content.setBorder(BorderFactory.createCompoundBorder(space, BorderFactory.createCompoundBorder(frame, space)));

		//Bild hinzuefgen
		ImageIcon imageIcon = new ImageIcon((new Iconkit(this)).loadImageResource(Resource.getString("MMART_IMAGE_SMALL")));;
		JLabel logoLabel = new JLabel(imageIcon);
		content.add(logoLabel);

		//InfoText hinzuefgen
		content.add(setInfotext());

		getContentPane().add(content);
		setResizable(false);
		pack();
		setLocation(owner.getX() + (owner.getWidth() - this.getWidth()) /2, owner.getY() + (owner.getHeight() - this.getHeight()) /2);
		setVisible(true);
	}
	
	/**
	 * This method should be overwritten.
	 */
	protected JPanel setInfotext() {
		JPanel jP = new JPanel();
        
		jP.setLayout(new GridLayout(9,1));

		jP.add(new JLabel(" MiningMart ", JLabel.CENTER));
		jP.add(new JLabel(""));//Leerzeile
		jP.add(new JLabel(" Developed by: ", JLabel.CENTER));		
		jP.add(new JLabel(" Martin Scholz, Timm Euler, Daniel Hakenjos, Katharina Morik ", JLabel.CENTER));
		jP.add(new JLabel(""));
		jP.add(new JLabel(" Copyright 2006 by the developers. ", JLabel.CENTER));
		String licenseFileName = System.getProperty(MiningMartApplication.SYSTEM_PROP_MM_HOME) +
		                         File.separator + "LICENSE";
		jP.add(new JLabel(" For licensing information see the file '" + licenseFileName + "'. ", JLabel.CENTER));
		jP.add(new JLabel(""));
		jP.add(new JLabel(" See also http://mmart.cs.uni-dortmund.de", JLabel.CENTER)); 		

		return jP;
	}

}
/*
$Log: AboutDialog.java,v $
Revision 1.6  2006/09/27 15:00:01  euler
New version 1.1

Revision 1.5  2006/04/11 16:01:33  euler
Updated info

Revision 1.4  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.3  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.2  2006/03/30 11:30:53  euler
Updated message.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

 */
		
