/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.exception;
/**
 * This Exception is thrown when something goes wrong in the
 * process of de-serialization which is caused by a corrupt
 * XML export file.
 * 
 * @author Martin Scholz
 * @version $Id: XmlException.java,v 1.4 2006/09/27 15:00:00 euler Exp $
 */
public class XmlException extends MiningMartException {

	public XmlException()
	{ super(); }
	
	public XmlException(String message) {
		super(message);	
	}

	public XmlException(String tag, String embedded) {
		super("XmlException when parsing the tag '"
				+ (tag == null ? "<null>" : tag)
				+ "' with the embedded String:\n"
				+ (embedded == null ? "<null>" : embedded)
				+ "\n");
	}
	
}
/*
 * Historie
 * --------
 *
 * $Log: XmlException.java,v $
 * Revision 1.4  2006/09/27 15:00:00  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:37  hakenjos
 * Initial version!
 *
 */
