/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.Sequence;

import java.io.Reader;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;

/**
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: CorrelResultParser.java,v 1.5 2006/09/27 15:00:04 euler Exp $
 */
public class CorrelResultParser {
   	DLFTokenizer m_st;

	public CorrelResultParser(Reader r) {
   		m_st = new DLFTokenizer(r);
	}

	protected Pattern parsePattern() throws Exception {
		Pattern p=new Pattern();
		m_st.checkBeginRecord();
		p.setText(m_st.getString());
		p.setStartPos((int)m_st.getNumber());
		p.setEndPos((int)m_st.getNumber());
		m_st.checkEndRecord();
		return p;
	}
	protected Patterns parsePatterns() throws Exception {
		Patterns p=new Patterns();
		m_st.checkBeginRecord();
		p.setVal(m_st.getNumber());
		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			p.addPattern(parsePattern());
		}
		m_st.checkEndRecord();
		return p;
	}
	public CorrelResult parse() throws Exception {

		CorrelResult cr=new CorrelResult();

		m_st.nextToken();
		if(!m_st.getWord().equals("patterns")) {
			throw new Exception(m_st.errorMsg(
				"expected patterns word"));
		};

		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			cr.addPatterns(parsePatterns());
		}
		m_st.checkEOF();
		return cr;
	}
};

/*
 * Historie
 * --------
 * 
 * $Log: CorrelResultParser.java,v $
 * Revision 1.5  2006/09/27 15:00:04  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:11  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */
