/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.Sequence;

import java.sql.SQLException;
import java.util.Vector;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DMException;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ToPLSql;

/**
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: CorrelResult2PLSql.java,v 1.5 2006/09/27 15:00:04 euler Exp $
 */
public class CorrelResult2PLSql extends ToPLSql {

	public CorrelResult2PLSql() {
		super();
	}
	protected void printPatternOn(Pattern r, int id) 
			throws Exception {
			this.getM4Db().executeBusinessSqlWrite("insert into " + m_result_name +
			"_tab values ("+ id + ",'" + r.getText()+"'," + r.getStartPos() + "," +
			r.getEndPos()+")\n");
	}
	
	protected void printPatternsOn(Patterns r, int id) 
			throws Exception {
		Vector p=r.getPatterns();
		int i;
		for(i=0; i<p.size(); ++i) {
			printPatternOn((Pattern)(p.elementAt(i)),id);
		}
	}
	
	public void convertOn(CorrelResult r) throws Exception {
		Vector p=r.getPatternsSet();
		int i;
		for(i=0; i<p.size(); ++i) {
			printPatternsOn((Patterns)(p.elementAt(i)),i);
		}
	}
	
	public void convert(Object o) throws Exception {
		try {
			String q1="DROP TABLE "+m_result_name+"_tab";
			String q2="CREATE TABLE "+m_result_name+"_tab ("
				+"	id int,"
				+"	text varchar(100),"
				+"	start_pos int,"
				+"	end_pos int"
				+")";
			System.out.print("Query: "+q2+"\n");
			try {
				this.getM4Db().executeBusinessSqlWrite(q1);
			} catch(Exception e) {}
			this.getM4Db().executeBusinessSqlWrite(q2);
			convertOn((CorrelResult)o);
			this.getM4Db().commitBusinessTransactions();
		} catch(SQLException e) {
			throw new DMException("Wrapper: Error tryning"+
			" to insert result into table:" + e.getMessage());
		} 
	}
	
};

/*
 * Historie
 * --------
 * 
 * $Log: CorrelResult2PLSql.java,v $
 * Revision 1.5  2006/09/27 15:00:04  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:11  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */
