/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;

import edu.udo.cs.miningmart.operator.ExecutableOperator;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ColumnInfo;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.C45Wrapper;

import edu.udo.cs.miningmart.m4.Step;

/**
 * @author Alessandro Serra
 * @version $Id: MMS3Wrapper.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class MMS3Wrapper extends C45Wrapper {
	protected Centers m_centers;
	protected int m_cluster_num;
	protected boolean m_optimize_cluster_num;

	public MMS3Wrapper(Step step, ExecutableOperator exOp) throws Exception {
		super(step, exOp);
		m_cluster_num=5;
		m_optimize_cluster_num=true;
	}
	public void setClusterNum(int n) {
		m_cluster_num=n;
	}
	public int getClusterNum() {
		return m_cluster_num;
	}
	public void setOptimizeClusterNum(boolean v) {
		m_optimize_cluster_num=v;
	}
	
	public void checkMetaData() throws Exception {
		if(m_md.getColumnToLearn()!=null) {
			throw new Exception("MMS3 is a supervised"+
				" learning algoritm."+
				" It don't require a column to learn");
		}
		int i;
		for(i=0; i<m_md.getColumnInfos().size(); ++i) {
			ColumnInfo ci=(ColumnInfo)
				m_md.getColumnInfos().elementAt(i);
			if(ci.getConceptType()==ColumnInfo.ORDINAL) {
				ci.setConceptType(ColumnInfo.CATEGORIAL);
			}
		}
	}

	protected void callTool() throws Exception {
		if(m_optimize_cluster_num) {
			callScript("mms3 "+m_file_name+" kmax "+
				m_cluster_num);
		} else {
			callScript("mms3 "+m_file_name+" k "+
				m_cluster_num);
		}
	}
	protected void importResult() throws Exception {
		Reader r = new BufferedReader(new FileReader(m_file_name
				+"_mms3.dlf"));
		CentersParser tp=new CentersParser(r);
		m_centers=tp.parse();
		m_cluster_num=m_centers.getCenters().size();
	}
	protected void saveResult() throws Exception {
		Centers2PLSql t2sql=new Centers2PLSql();
		t2sql.setMetaData(m_md);
		t2sql.setConnection(this.getM4Db());
		t2sql.setResultName(m_result_name);
		t2sql.convert(m_centers);
	}	
};
/*
 * Historie
 * --------
 * 
 * $Log: MMS3Wrapper.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:40  hakenjos
 * Initial version!
 *
 */
