/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3;

import java.io.PrintWriter;
import java.util.Vector;

import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Attribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.C452PLSql;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NominalAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NumericAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Schema;

/**
 * @author Alessandro Serra, Timm Euler
 * @version $Id: Centers2PLSql.java,v 1.5 2006/09/27 15:00:03 euler Exp $
 */
public class Centers2PLSql extends C452PLSql {

	public Centers2PLSql() {
		super();
	}
	protected void printNominalValueOn(PrintWriter w, 
			NominalAttribute a, String s) {
		w.print("if ");
		printAttr(w,a.getName());
		w.print(" != ");
		printValue(w,s,m_md.findColumnInfo(a.getName()));
		w.print(" then d:=d+"+a.getWeight()+"; end if; ");
	}
	protected void printNumericValueOn(PrintWriter w, 
			NumericAttribute a, Double n) {
		w.print("d:=d+"+a.getWeight()+"*abs(");
		printAttr(w,a.getName());
		w.print("-");
		printValue(w,n,m_md.findColumnInfo(a.getName()));
		w.print(")/");
		w.print(a.getRangeWide());
		w.print(";");
	}
	protected void printValueOn(PrintWriter w, Attribute a, Object n) {
		if(a instanceof NumericAttribute) {
			printNumericValueOn(w,(NumericAttribute)a,(Double)n);
		} else if( a instanceof NominalAttribute) {
			printNominalValueOn(w,(NominalAttribute)a,(String)n);
		}
	}
	protected void printCenterOn(PrintWriter w, Schema s, Center c) {
		Vector v=c.getValues();
		int i;
		w.print("\td:=0;\n");
		for(i=0; i<v.size(); ++i) {
			w.print("\t");
			printValueOn(w,(Attribute)
				s.getAttributes().elementAt(i),v.elementAt(i));
			w.print("\n");
		}
		w.print("");
	}
	public void convertToFunctionOn(PrintWriter w, Centers c) {
		printFuncHeader(w);
		Vector r=c.getCenters();
		int i;
		for(i=0; i<r.size(); ++i) {
			printCenterOn(w,c.getSchema(),
				((Center)(r.elementAt(i))));
			if(i==0) {
				w.print("\tdmin:=d;\n");
				w.print("\timin:=0;\n");
			} else {
				w.print("\tif d<dmin then\n");
				w.print("\t\tdmin:=d;\n");
				w.print("\t\timin:="+i+";\n");
				w.print("\tend if;\n");
			}
		}
		w.print("\treturn imin;\n");
		printFuncTrailer(w);
	}
	public void convertToFunctionOn(PrintWriter w, Object o) 
			throws Exception {
		convertToFunctionOn(w, (Centers)o);
	}
	
	protected void printFuncDeclaration(PrintWriter w) {
		w.print("\td NUMBER;\n");
		w.print("\tdmin NUMBER;\n");
		w.print("\timin NUMBER;\n");
	}
};
/*
 * Historie
 * --------
 * 
 * $Log: Centers2PLSql.java,v $
 * Revision 1.5  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:40  hakenjos
 * Initial version!
 *
 */
