/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.FS;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;

import edu.udo.cs.miningmart.operator.ExecutableOperator;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ColumnInfo;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.C45Wrapper;

import edu.udo.cs.miningmart.m4.Step;

/**
 * Superclass for feature selection wrappers.
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: FeatureSelectionWrapper.java,v 1.5 2006/09/27 15:00:04 euler Exp $
 */
public abstract class FeatureSelectionWrapper extends C45Wrapper {
	public Vector m_feature_selected;
	public Vector m_feature_rejected;

	public FeatureSelectionWrapper(Step step, ExecutableOperator exOp) throws Exception {
		super(step, exOp);
	}
	
	protected void importResult() throws Exception {
		Reader r = new BufferedReader(new FileReader(m_file_name
				+".tbl"));
		FeatureSelectionParser tp=new FeatureSelectionParser(r);
		m_feature_selected=tp.parse();
		m_feature_rejected=new Vector();

		int i;
		for(i=0; i<m_md.getColumnInfos().size(); ++i) {
			ColumnInfo ci=(ColumnInfo)m_md.getColumnInfos().elementAt(i);
			int j;
			for(j=0; j<m_feature_selected.size(); ++j) {
				if(m_feature_selected.elementAt(j).equals(ci.getName())) {
					break;
				}
			}	
			if(j==m_feature_selected.size()) {
				m_feature_rejected.add(ci.getName());
			}
		}
	}
	
	protected void saveResult() throws Exception {
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: FeatureSelectionWrapper.java,v $
 * Revision 1.5  2006/09/27 15:00:04  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:34  hakenjos
 * Initial version!
 *
 */
