/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista;

import java.io.Reader;
import java.io.StreamTokenizer;

/**
 * A tool for Dista's wrappers.
 * 
 * @author Alessandro Serra
 * @version $Id: DLFTokenizer.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class DLFTokenizer extends StreamTokenizer {
	public DLFTokenizer(Reader r) {
		super(r);
		quoteChar('\'');
	}

	final public String errorMsg(String m) {
		String msg="Error in line "+lineno()+" : "+m;
		msg=msg+". Status ["+(char)ttype+" "+sval+" "+nval+"] ";
		return msg;
	}
	final public String getWord() throws Exception {
		if(ttype!=TT_WORD) {
			throw new DMException(errorMsg("Expected Word"));
		}
		String s=sval;
		nextToken();
		return s;	
	}
	final public String getString() throws Exception {
		if(ttype!='\'') {
			throw new DMException(errorMsg("Expected String"));
		}
		String s=sval;
		nextToken();
		return s;	
	}
	final public double getNumber() throws Exception {
		if(ttype!=TT_NUMBER) {
			throw new DMException(errorMsg("Expected Number"));
		}
		double s=nval;
		nextToken();
		return s;	
	}
	final public Double getNumericValue() throws Exception {
		Double v;
		if(ttype==TT_NUMBER) {
			v=new Double(nval);
		} else if(ttype==TT_WORD && sval.equals("null")) {
			v=null;
		} else if(ttype=='?') {
			v=null;
		} else {
			throw new DMException(errorMsg("Expected a Numeric Value"));
		}
		nextToken();
		return v;	
	}
	final public String getNominalValue() throws Exception {
		String v;
		if(ttype=='\'') {
			v=sval;
		} else if(ttype==TT_WORD && sval.equals("null")) {
			v=null;
		} else if(ttype=='?') {
			v=null;
		} else {
			throw new DMException(errorMsg("Expected a Nominal Value"));
		}
		nextToken();
		return v;	
	}
	final public void checkBeginRecord() throws Exception {
		if(ttype!='[')
			throw new DMException(errorMsg("Expected Begin Record"));	
		nextToken();
	}
	final public void checkEndRecord() throws Exception {
		if(ttype!=']')
			throw new DMException(errorMsg("Expected End Record"));	
		nextToken();
	}
	final public void checkBeginList() throws Exception {
		if(ttype!='(')
			throw new DMException(errorMsg("Expected Begin List"));	
		nextToken();
	}
	final public void checkEndList() throws Exception {
		if(ttype!=')')
			throw new DMException(errorMsg("Expected End List"));	
		nextToken();
	}
	final public boolean isEndList() throws Exception {
		if(ttype==')') {
			nextToken();
			return true;
		} else {
			return false;
		}
	}
	final public boolean isEndRecord() throws Exception {
		if(ttype==']') {
			nextToken();
			return true;
		} else {
			return false;
		}
	}
	final public void checkEOF() throws Exception {
		if(ttype!=TT_EOF)
			throw new DMException(errorMsg("Expected EOF"));	
	}
	final public boolean isEOF() throws Exception {
		if(ttype!=TT_EOF) {
			return true;
		} else {
			return false;
		}
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: DLFTokenizer.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
