/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import java.io.PrintWriter;
import java.util.Vector;

/**
 * @author Alessandro Serra
 * @version $Id: Tree2PLSql.java,v 1.5 2006/09/27 14:59:54 euler Exp $
 */
public class Tree2PLSql extends C452PLSql {

	public Tree2PLSql() {
		super();
	}

	protected void printNominalNodeOn(PrintWriter w, NominalNode n, int s) {
		Vector c=n.getChildren();
		Vector cv=n.getValueNames();
		int i;
		for(i=0; i<c.size(); ++i) {
			printSpaceOn(w,s);
			if(i==0) {
				w.print("if  ");
			} else {
				w.print("elsif  ");
			}
			printAttr(w,n.getAttr().getName());
			w.print(" = ");
			printValue(w,(String)(cv.elementAt(i)),
				m_md.findColumnInfo(n.getAttr().getName()));
			w.print("  then \n");
			printNodeOn(w,((Node)c.elementAt(i)),s+1);
		}
		printSpaceOn(w,s);
		w.print("end if;\n");
	}
	protected void printNumericNodeOn(PrintWriter w, NumericNode n, int s) {
		printSpaceOn(w,s);
		w.print("if ");
		printAttr(w,n.getAttr().getName());
		w.print(" <= ");
		printValue(w,new Double(n.getValue()),
			m_md.findColumnInfo(n.getAttr().getName()));
		w.print(" then\n");
		printNodeOn(w,(Node)(n.getChildren().elementAt(0)),s+1);
		printSpaceOn(w,s);
		w.print("else\n");
		printNodeOn(w,(Node)(n.getChildren().elementAt(1)),s+1);
		printSpaceOn(w,s);
		w.print("end if;\n");
	}
	protected void printReturnNodeOn(PrintWriter w, ReturnNode n, int s) {
		printSpaceOn(w,s);
		w.print("return ");
		printValue(w,n.getReturnValueName(),m_md.getColumnToLearn());
		w.print(";\n");
	}
	protected void printNodeOn(PrintWriter w, Node n, int s) {
		if(n instanceof NumericNode) {
			printNumericNodeOn(w,(NumericNode)n,s);
		} else if(n instanceof NominalNode) {
			printNominalNodeOn(w,(NominalNode)n,s);
		} else if(n instanceof ReturnNode) {
			printReturnNodeOn(w,(ReturnNode)n,s);
		}
	}
	public void convertToFunctionOn(PrintWriter w, Tree tree) {
		printFuncHeader(w);
		printNodeOn(w,tree.getRoot(),1);
		printFuncTrailer(w);
	}

	public void convertToFunctionOn(PrintWriter w, Object o) 
			throws Exception {
		convertToFunctionOn(w, (Tree)o);
	}
};

/*
 * Historie
 * --------
 * 
 * $Log: Tree2PLSql.java,v $
 * Revision 1.5  2006/09/27 14:59:54  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:11  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
