/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;
import edu.udo.cs.miningmart.compiler.wrapper.dista.DMException;


/**
 * @author Alessandro Serra
 * @version $Id: RulesParser.java,v 1.5 2006/09/27 14:59:54 euler Exp $
 */
public class RulesParser {
   	DLFTokenizer m_st;
	Schema l_schema;

	public RulesParser(Reader r) {
   		m_st = new DLFTokenizer(r);
	}
	protected Attribute parseAttr() throws Exception {
		Attribute attr=null;
		String ty=m_st.getWord();
		if(ty.equals("nom")) {
			m_st.checkBeginRecord();
			attr=new NominalAttribute();
			attr.setName(m_st.getString());
			m_st.checkEndRecord();
		} else if(ty.equals("num")) {
			m_st.checkBeginRecord();
			attr=new NumericAttribute();
			attr.setName(m_st.getString());
			m_st.checkEndRecord();
		} else {
			throw new DMException(
			m_st.errorMsg("expected nom/num words"));
		}
		return attr;
	}
	protected Cond parseNominalCond() throws Exception {
		NominalCond cond=new NominalCond();
	
		m_st.checkBeginRecord();
		if(!m_st.getWord().equals("eq")) {
			throw new DMException(
				m_st.errorMsg("expected = string"));
		}
		cond.setAttr(l_schema.findAttr(m_st.getString()));
		cond.setValueName(m_st.getString());
		m_st.checkEndRecord();
		return cond;
	}
	protected Cond parseNumericCond() throws Exception {
		NumericCond cond=new NumericCond();
		
		m_st.checkBeginRecord();
		cond.setOp(m_st.getWord());
		cond.setAttr(l_schema.findAttr(m_st.getString()));
		cond.setValue(m_st.getNumber());
		m_st.checkEndRecord();

		return cond;
	}
	protected Cond parseCond() throws Exception {

		Cond n=null;
		String ty=m_st.getWord();
		if(ty.equals("nom")) {
			n=parseNominalCond();
		} else if(ty.equals("num")) {
			n=parseNumericCond();
		} else {
			throw new DMException(
			m_st.errorMsg("expected nom/num words"));
		}
		return n;
	}
	protected Rule parseRule() throws Exception {
		
		Rule r=new Rule();
		m_st.checkBeginRecord();
		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			r.addCond(parseCond());
		}
		r.setReturnValueName(m_st.getString());
		m_st.checkEndRecord();
		return r;
	}

	public Rules parse() throws Exception {

		Rules rules=new Rules();
		l_schema=new Schema();
		rules.setSchema(l_schema);

		m_st.nextToken();
		if(!m_st.getWord().equals("rules")) {
			throw new DMException(
				m_st.errorMsg("expected rules word"));
		};
		m_st.checkBeginRecord();

		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			l_schema.addAttr(parseAttr());
		}
		
		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			rules.addRule(parseRule());
		}
		rules.setDefReturnValueName(m_st.getString());

		m_st.checkEndRecord();
		m_st.checkEOF();

		l_schema=null;
		return rules;
	}

	public static void main(String args[]) {
		Rules rules;
		try {
			Reader r = new BufferedReader(new FileReader(args[0]));
			RulesParser tp=new RulesParser(r);
			
			rules=tp.parse();
			
			Writer w= new BufferedWriter(new FileWriter(args[1]));
			PrintWriter pw=new PrintWriter(w);
			
			rules.dumpOn(pw);
			pw.close();
			w.close();	
			
		} catch(Exception e) {
			System.out.print(e+"\n");
		}
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: RulesParser.java,v $
 * Revision 1.5  2006/09/27 14:59:54  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
