/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import java.io.PrintWriter;
import java.util.Vector;

/**
 * @author Alessandro Serra
 * @version $Id: Rules2PLSql.java,v 1.5 2006/09/27 14:59:54 euler Exp $
 */
public class Rules2PLSql extends C452PLSql {

	public Rules2PLSql() {
		super();
	}
	protected void printNominalCondOn(PrintWriter w, NominalCond n) {
		printAttr(w,n.getAttr().getName());
		w.print(" = ");
		printValue(w,n.getValueName(),
			m_md.findColumnInfo(n.getAttr().getName()));
	}
	protected void printNumericCondOn(PrintWriter w, NumericCond n) {
		printAttr(w,n.getAttr().getName());
		w.print(" "+n.getOpSymbol()+" ");
		printValue(w,new Double(n.getValue()),
			m_md.findColumnInfo(n.getAttr().getName()));
	}
	protected void printCondOn(PrintWriter w, Cond n) {
		if(n instanceof NumericCond) {
			printNumericCondOn(w,(NumericCond)n);
		} else if(n instanceof NominalCond) {
			printNominalCondOn(w,(NominalCond)n);
		}
	}
	protected void printRuleOn(PrintWriter w, Rule rule) {
		Vector c=rule.getConds();
		int i;
		w.print("if ");
		for(i=0; i<c.size(); ++i) {
			if(i!=0) w.print(" and \n");
			w.print("\t( ");
			printCondOn(w,((Cond)(c.elementAt(i))));
			w.print(" ) ");
		}
		w.print("then return ");
		printValue(w,rule.getReturnValueName(),
			m_md.getColumnToLearn());
		w.print(";\nend if;\n");
	}

	public void convertToFunctionOn(PrintWriter w, Rules rules) {
		printFuncHeader(w);
		Vector r=rules.getRules();
		int i;
		for(i=0; i<r.size(); ++i) {
			printRuleOn(w,((Rule)(r.elementAt(i))));
		}
		w.print("return ");
		printValue(w,rules.getDefReturnValueName(),
			m_md.getColumnToLearn());
		w.print(";\n");
		printFuncTrailer(w);
	}
	public void convertToFunctionOn(PrintWriter w, Object o) 
			throws Exception {
		convertToFunctionOn(w, (Rules)o);
	}
};
/*
 * Historie
 * --------
 * 
 * $Log: Rules2PLSql.java,v $
 * Revision 1.5  2006/09/27 14:59:54  euler
 * New version 1.1
 *
 * Revision 1.4  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
